{extends "apps/{$config.theme}/main/templates/container.tpl"}

{block name="additional_static"}
<script src="{$theme_url}/main/static/js/libs/gridAlicious/jquery.grid-a-licious.js"></script>
<script src="{$theme_url}/main/static/js/libs/jquery.equalheights.js"></script>
{/block}

{block name="content"}
	<div class="user-profile-page-content">
		<div class="user-heading">
			<div class="container container-profile user-info">
				<div class="avatar animated bounceIn">
					<img src="{$user_data.avatar}" class="img-circle">
				</div>
				<div class="info">	
					<div class="uname animated fadeInUpBig">
						<a href="{$user_data.url}">
							<h4>{$user_data.username}</h4>
						</a>
						{if IS_LOGGED}
							<div class="modal-menu dropdown">
							<span class="dropdown-toggle" data-toggle="dropdown">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-more-horizontal"><circle cx="12" cy="12" r="1"></circle><circle cx="19" cy="12" r="1"></circle><circle cx="5" cy="12" r="1"></circle></svg>
							</span>
							<ul class="dropdown-menu zoom">
								{if $is_owner}
									<li><a href="{$site_url}/settings/privacy/{$me.username}">{lang('profile_privacy')}</a></li>
									<li><a href="{$site_url}/settings/notifications/{$me.username}">{lang('notifications')}</a></li>
									<li><a href="{$site_url}/signout">{lang('logout')}</a></li>
								{/if}

								{if not $is_owner}
									{if $is_reported}
										<li class="report-profile" onclick="report_profile('{$user_data.user_id}',-1);"><a href="javascript:void(0);">{lang('cancel_report')}</a></li>
									{else}
										<li class="report-profile" data-modal-menu="report-profile"><a href="javascript:void(0);">{lang('report_user')}</a></li>
									{/if}
							
									{if $is_blocked}
										<li onclick="block_user('{$user_data.user_id}',-1);"><a href="javascript:void(0);">{lang('unblock')}</a></li>
									{else}
										<li onclick="block_user('{$user_data.user_id}',1);"><a href="javascript:void(0);">{lang('block_user')}</a></li>
									{/if}
								{/if}
							</ul>
							</div>	
						{/if}
					</div>
		            <div class="clear"></div>
		            <p class="fluid status animated fadeInUpBig">
						{$user_data.about}
					</p>
					<ul class="navbar-nav nav justify-content-center social-links animated fadeInUpBig">
						{if $user_data.website}
							<li class="btn-website">
								<a href="{$user_data.website}" rel="nofollow"><svg xmlns="http://www.w3.org/2000/svg" class="feather feather-website" width="24" height="24" viewBox="0 0 24 24" fill="#f3f3f3"><path d="M16.36,14C16.44,13.34 16.5,12.68 16.5,12C16.5,11.32 16.44,10.66 16.36,10H19.74C19.9,10.64 20,11.31 20,12C20,12.69 19.9,13.36 19.74,14M14.59,19.56C15.19,18.45 15.65,17.25 15.97,16H18.92C17.96,17.65 16.43,18.93 14.59,19.56M14.34,14H9.66C9.56,13.34 9.5,12.68 9.5,12C9.5,11.32 9.56,10.65 9.66,10H14.34C14.43,10.65 14.5,11.32 14.5,12C14.5,12.68 14.43,13.34 14.34,14M12,19.96C11.17,18.76 10.5,17.43 10.09,16H13.91C13.5,17.43 12.83,18.76 12,19.96M8,8H5.08C6.03,6.34 7.57,5.06 9.4,4.44C8.8,5.55 8.35,6.75 8,8M5.08,16H8C8.35,17.25 8.8,18.45 9.4,19.56C7.57,18.93 6.03,17.65 5.08,16M4.26,14C4.1,13.36 4,12.69 4,12C4,11.31 4.1,10.64 4.26,10H7.64C7.56,10.66 7.5,11.32 7.5,12C7.5,12.68 7.56,13.34 7.64,14M12,4.03C12.83,5.23 13.5,6.57 13.91,8H10.09C10.5,6.57 11.17,5.23 12,4.03M18.92,8H15.97C15.65,6.75 15.19,5.55 14.59,4.44C16.43,5.07 17.96,6.34 18.92,8M12,2C6.47,2 2,6.5 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z" /></svg><span>{$user_data.website}</span></a>
							</li>
						{/if}
						{if $user_data.google}
							<li class="btn-social">
								<a href="{$user_data.google}"><svg xmlns="http://www.w3.org/2000/svg" class="feather feather-google" width="24" height="24" viewBox="0 0 24 24" fill="#db4437"><path d="M23,11H21V9H19V11H17V13H19V15H21V13H23M8,11V13.4H12C11.8,14.4 10.8,16.4 8,16.4C5.6,16.4 3.7,14.4 3.7,12C3.7,9.6 5.6,7.6 8,7.6C9.4,7.6 10.3,8.2 10.8,8.7L12.7,6.9C11.5,5.7 9.9,5 8,5C4.1,5 1,8.1 1,12C1,15.9 4.1,19 8,19C12,19 14.7,16.2 14.7,12.2C14.7,11.7 14.7,11.4 14.6,11H8Z" /></svg></a>
							</li>
						{/if}

						{if $user_data.facebook}
							<li class="btn-social">
								<a href="{$user_data.facebook}"><svg xmlns="http://www.w3.org/2000/svg" class="feather feather-facebook" width="24" height="24" viewBox="0 0 24 24" fill="#4267b3"><path d="M17,2V2H17V6H15C14.31,6 14,6.81 14,7.5V10H14L17,10V14H14V22H10V14H7V10H10V6A4,4 0 0,1 14,2H17Z" /></svg></a>
							</li>
						{/if}
						{if $user_data.twitter}
							<li class="btn-social">
								<a href="{$user_data.twitter}"><svg xmlns="http://www.w3.org/2000/svg" class="feather feather-twitter" width="24" height="24" viewBox="0 0 24 24" fill="#1da1f2"><path d="M22.46,6C21.69,6.35 20.86,6.58 20,6.69C20.88,6.16 21.56,5.32 21.88,4.31C21.05,4.81 20.13,5.16 19.16,5.36C18.37,4.5 17.26,4 16,4C13.65,4 11.73,5.92 11.73,8.29C11.73,8.63 11.77,8.96 11.84,9.27C8.28,9.09 5.11,7.38 3,4.79C2.63,5.42 2.42,6.16 2.42,6.94C2.42,8.43 3.17,9.75 4.33,10.5C3.62,10.5 2.96,10.3 2.38,10C2.38,10 2.38,10 2.38,10.03C2.38,12.11 3.86,13.85 5.82,14.24C5.46,14.34 5.08,14.39 4.69,14.39C4.42,14.39 4.15,14.36 3.89,14.31C4.43,16 6,17.26 7.89,17.29C6.43,18.45 4.58,19.13 2.56,19.13C2.22,19.13 1.88,19.11 1.54,19.07C3.44,20.29 5.7,21 8.12,21C16,21 20.33,14.46 20.33,8.79C20.33,8.6 20.33,8.42 20.32,8.23C21.16,7.63 21.88,6.87 22.46,6Z" /></svg></a>
							</li>
						{/if}
					</ul>
					{if not $is_owner and not $is_blocked}
						{if $is_following}
							<button class="btn btn-follow btn-following animated fadeInUpBig" onclick="follow({$user_data.user_id},this);">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user-check"><path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="8.5" cy="7" r="4"></circle><polyline points="17 11 19 13 23 9"></polyline></svg> <span>{lang('following')}</span>
							</button>
						{else}
							<button class="btn btn-follow animated fadeInUpBig" onclick="follow({$user_data.user_id},this);">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user-plus"><path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="8.5" cy="7" r="4"></circle><line x1="20" y1="8" x2="20" y2="14"></line><line x1="23" y1="11" x2="17" y2="11"></line></svg> <span>{lang('follow')}</span>
							</button>
						{/if}
						{if $chat_privacy}
							<a href="{$site_url}/messages/{$user_data.username}" class="btn btn-follow btn-message btn_links animated fadeInUpBig">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-message-square"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg> <span>{lang('message')}</span>
							</a>
						{/if}
					{/if}
					{if $is_blocked}
						<button class="btn btn-info btn-unblock animated fadeInUpBig" onclick="block_user('{$user_data.user_id}',-1);"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-unlock"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 9.9-1"></path></svg> {lang('unblock')}</button>
					{/if}
					{if $is_owner or IS_ADMIN}
						<a href="{$site_url}/settings/general/{$user_data.username}" class="btn btn-info btn_links animated fadeInUpBig">
							<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit"><polygon points="14 2 18 6 7 17 3 17 3 13 14 2"></polygon><line x1="3" y1="22" x2="21" y2="22"></line></svg> {lang('profile_settings')}
						</a>
					{/if}
				</div>
			</div>
		</div>
		
		<div class="navbar-bottom">
			<div class="container container-profile">
				<ul class="navbar-nav nav justify-content-center">
					<li class="nav-item {if $page == 'posts'}active{/if}">
						<a class="nav__item" {if $navbar}href="{$user_data.url}/posts"{/if}>
							{$total_posts}<span>  {lang('posts')}</span>
						</a>
					</li>
					<li class="nav-item {if $page == 'followers'}active{/if}">
						<a class="nav__item" {if $user_followers and $navbar}href="{$user_data.url}/followers"{/if}>
							{$user_followers} <span>{lang('followers')}</span>
						</a>
					</li>
					<li class="nav-item {if $page == 'following'}active{/if}">
						<a class="nav__item" {if $user_following and $navbar}href="{$user_data.url}/following"{/if}>
							{$user_following}<span> {lang('following')}</span>
						</a>
					</li>
					{if $is_owner == true}
						<li class="nav-item {if $page == 'favourites'}active{/if}">
							<a class="nav__item" {if $favourites}href="{$user_data.url}/favourites"{/if}>
								{$favourites}<span> {lang('favourites')}</span>
							</a>
						</li>
					{/if}
				</ul>
			</div>
		</div>
		
		{if $is_blocked}
			<div class="profile-blocked container">
				<h5 class="empty_state">
					<svg xmlns="http://www.w3.org/2000/svg" class="confetti" viewBox="0 0 1081 601"><path class="st0" d="M711.8 91.5c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C695.2 84 702.7 91.5 711.8 91.5zM711.8 64.1c5.9 0 10.7 4.8 10.7 10.7s-4.8 10.7-10.7 10.7 -10.7-4.8-10.7-10.7S705.9 64.1 711.8 64.1z"/><path class="st0" d="M74.5 108.3c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C57.9 100.9 65.3 108.3 74.5 108.3zM74.5 81c5.9 0 10.7 4.8 10.7 10.7 0 5.9-4.8 10.7-10.7 10.7s-10.7-4.8-10.7-10.7S68.6 81 74.5 81z"/><path class="st1" d="M303 146.1c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C286.4 138.6 293.8 146.1 303 146.1zM303 118.7c5.9 0 10.7 4.8 10.7 10.7 0 5.9-4.8 10.7-10.7 10.7s-10.7-4.8-10.7-10.7C292.3 123.5 297.1 118.7 303 118.7z"/><path class="st2" d="M243.4 347.4c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7S234.2 347.4 243.4 347.4zM243.4 320c5.9 0 10.7 4.8 10.7 10.7 0 5.9-4.8 10.7-10.7 10.7s-10.7-4.8-10.7-10.7S237.5 320 243.4 320z"/><path class="st1" d="M809.8 542.3c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C793.2 534.8 800.7 542.3 809.8 542.3zM809.8 514.9c5.9 0 10.7 4.8 10.7 10.7s-4.8 10.7-10.7 10.7 -10.7-4.8-10.7-10.7S803.9 514.9 809.8 514.9z"/><path class="st3" d="M1060.5 548.3c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C1043.9 540.8 1051.4 548.3 1060.5 548.3zM1060.5 520.9c5.9 0 10.7 4.8 10.7 10.7s-4.8 10.7-10.7 10.7 -10.7-4.8-10.7-10.7S1054.6 520.9 1060.5 520.9z"/><path class="st3" d="M387.9 25.2l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L387.9 25.2z"/><path class="st3" d="M368.3 498.6l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L368.3 498.6z"/><path class="st3" d="M16.4 270.2l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L16.4 270.2z"/><path class="st2" d="M824.7 351.1l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L824.7 351.1z"/><path class="st1" d="M146.3 573.6H138v-8.3c0-1.3-1-2.3-2.3-2.3s-2.3 1-2.3 2.3v8.3h-8.3c-1.3 0-2.3 1-2.3 2.3s1 2.3 2.3 2.3h8.3v8.3c0 1.3 1 2.3 2.3 2.3s2.3-1 2.3-2.3v-8.3h8.3c1.3 0 2.3-1 2.3-2.3S147.6 573.6 146.3 573.6z"/><path class="st1" d="M1005.6 76.3h-8.3V68c0-1.3-1-2.3-2.3-2.3s-2.3 1-2.3 2.3v8.3h-8.3c-1.3 0-2.3 1-2.3 2.3s1 2.3 2.3 2.3h8.3v8.3c0 1.3 1 2.3 2.3 2.3s2.3-1 2.3-2.3v-8.3h8.3c1.3 0 2.3-1 2.3-2.3S1006.8 76.3 1005.6 76.3z"/><path class="st1" d="M95.5 251.6c-3.5 0-6.3 2.8-6.3 6.3 0 3.5 2.8 6.3 6.3 6.3s6.3-2.8 6.3-6.3S99 251.6 95.5 251.6z"/><path class="st0" d="M1032 281.8c-3.5 0-6.3 2.8-6.3 6.3s2.8 6.3 6.3 6.3 6.3-2.8 6.3-6.3S1035.5 281.8 1032 281.8z"/><path class="st2" d="M741.6 139.3c-3.5 0-6.3 2.8-6.3 6.3s2.8 6.3 6.3 6.3 6.3-2.8 6.3-6.3S745 139.3 741.6 139.3z"/><path class="st3" d="M890.7 43.5c3.3 0 6-2.7 6-6s-2.7-6-6-6 -6 2.7-6 6C884.8 40.8 887.4 43.5 890.7 43.5z"/><path class="st0" d="M164.3 537.6c3.3 0 6-2.7 6-6s-2.7-6-6-6 -6 2.7-6 6C158.4 535 161 537.6 164.3 537.6z"/></svg>
					<svg xmlns="http://www.w3.org/2000/svg" fill="#607D8B" class="feather feather-block" width="24" height="24" viewBox="0 0 24 24"><path d="M15,14C17.67,14 23,15.33 23,18V20H7V18C7,15.33 12.33,14 15,14M15,12A4,4 0 0,1 11,8A4,4 0 0,1 15,4A4,4 0 0,1 19,8A4,4 0 0,1 15,12M5,9.59L7.12,7.46L8.54,8.88L6.41,11L8.54,13.12L7.12,14.54L5,12.41L2.88,14.54L1.46,13.12L3.59,11L1.46,8.88L2.88,7.46L5,9.59Z" /></svg>
				</h5>
				<h4>{lang('u_blocked_zis_usr')}</h4>
				<p>{lang('unblock2see_profile')}</p>
				<button class="btn btn-info error_unblock" onclick="block_user('{$user_data.user_id}',-1);"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-unlock"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 9.9-1"></path></svg> {lang('unblock')}</button>
			</div>
		{else}
			{if $user_data.p_privacy == '0' and not $is_owner}
				<div class="container container-profile">
					<div class="private-profile">
						<h5 class="empty_state">
							<svg xmlns="http://www.w3.org/2000/svg" class="confetti" viewBox="0 0 1081 601"><path class="st0" d="M711.8 91.5c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C695.2 84 702.7 91.5 711.8 91.5zM711.8 64.1c5.9 0 10.7 4.8 10.7 10.7s-4.8 10.7-10.7 10.7 -10.7-4.8-10.7-10.7S705.9 64.1 711.8 64.1z"/><path class="st0" d="M74.5 108.3c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C57.9 100.9 65.3 108.3 74.5 108.3zM74.5 81c5.9 0 10.7 4.8 10.7 10.7 0 5.9-4.8 10.7-10.7 10.7s-10.7-4.8-10.7-10.7S68.6 81 74.5 81z"/><path class="st1" d="M303 146.1c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C286.4 138.6 293.8 146.1 303 146.1zM303 118.7c5.9 0 10.7 4.8 10.7 10.7 0 5.9-4.8 10.7-10.7 10.7s-10.7-4.8-10.7-10.7C292.3 123.5 297.1 118.7 303 118.7z"/><path class="st2" d="M243.4 347.4c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7S234.2 347.4 243.4 347.4zM243.4 320c5.9 0 10.7 4.8 10.7 10.7 0 5.9-4.8 10.7-10.7 10.7s-10.7-4.8-10.7-10.7S237.5 320 243.4 320z"/><path class="st1" d="M809.8 542.3c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C793.2 534.8 800.7 542.3 809.8 542.3zM809.8 514.9c5.9 0 10.7 4.8 10.7 10.7s-4.8 10.7-10.7 10.7 -10.7-4.8-10.7-10.7S803.9 514.9 809.8 514.9z"/><path class="st3" d="M1060.5 548.3c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C1043.9 540.8 1051.4 548.3 1060.5 548.3zM1060.5 520.9c5.9 0 10.7 4.8 10.7 10.7s-4.8 10.7-10.7 10.7 -10.7-4.8-10.7-10.7S1054.6 520.9 1060.5 520.9z"/><path class="st3" d="M387.9 25.2l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L387.9 25.2z"/><path class="st3" d="M368.3 498.6l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L368.3 498.6z"/><path class="st3" d="M16.4 270.2l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L16.4 270.2z"/><path class="st2" d="M824.7 351.1l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L824.7 351.1z"/><path class="st1" d="M146.3 573.6H138v-8.3c0-1.3-1-2.3-2.3-2.3s-2.3 1-2.3 2.3v8.3h-8.3c-1.3 0-2.3 1-2.3 2.3s1 2.3 2.3 2.3h8.3v8.3c0 1.3 1 2.3 2.3 2.3s2.3-1 2.3-2.3v-8.3h8.3c1.3 0 2.3-1 2.3-2.3S147.6 573.6 146.3 573.6z"/><path class="st1" d="M1005.6 76.3h-8.3V68c0-1.3-1-2.3-2.3-2.3s-2.3 1-2.3 2.3v8.3h-8.3c-1.3 0-2.3 1-2.3 2.3s1 2.3 2.3 2.3h8.3v8.3c0 1.3 1 2.3 2.3 2.3s2.3-1 2.3-2.3v-8.3h8.3c1.3 0 2.3-1 2.3-2.3S1006.8 76.3 1005.6 76.3z"/><path class="st1" d="M95.5 251.6c-3.5 0-6.3 2.8-6.3 6.3 0 3.5 2.8 6.3 6.3 6.3s6.3-2.8 6.3-6.3S99 251.6 95.5 251.6z"/><path class="st0" d="M1032 281.8c-3.5 0-6.3 2.8-6.3 6.3s2.8 6.3 6.3 6.3 6.3-2.8 6.3-6.3S1035.5 281.8 1032 281.8z"/><path class="st2" d="M741.6 139.3c-3.5 0-6.3 2.8-6.3 6.3s2.8 6.3 6.3 6.3 6.3-2.8 6.3-6.3S745 139.3 741.6 139.3z"/><path class="st3" d="M890.7 43.5c3.3 0 6-2.7 6-6s-2.7-6-6-6 -6 2.7-6 6C884.8 40.8 887.4 43.5 890.7 43.5z"/><path class="st0" d="M164.3 537.6c3.3 0 6-2.7 6-6s-2.7-6-6-6 -6 2.7-6 6C158.4 535 161 537.6 164.3 537.6z"/></svg>
							<svg xmlns="http://www.w3.org/2000/svg" fill="#607D8B" class="feather feather-lock" width="24" height="24" viewBox="0 0 24 24"><path d="M12,17A2,2 0 0,0 14,15C14,13.89 13.1,13 12,13A2,2 0 0,0 10,15A2,2 0 0,0 12,17M18,8A2,2 0 0,1 20,10V20A2,2 0 0,1 18,22H6A2,2 0 0,1 4,20V10C4,8.89 4.9,8 6,8H7V6A5,5 0 0,1 12,1A5,5 0 0,1 17,6V8H18M12,3A3,3 0 0,0 9,6V8H15V6A3,3 0 0,0 12,3Z" /></svg>
						</h5>
						<h4>{lang('profile_is_private')}</h4>
					</div>
				</div>
			{elseif $user_data.p_privacy == '1' and not $is_following and not $is_owner}
				<div class="container container-profile">
					<div class="private-profile">
						<h5 class="empty_state">
							<svg xmlns="http://www.w3.org/2000/svg" class="confetti" viewBox="0 0 1081 601"><path class="st0" d="M711.8 91.5c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C695.2 84 702.7 91.5 711.8 91.5zM711.8 64.1c5.9 0 10.7 4.8 10.7 10.7s-4.8 10.7-10.7 10.7 -10.7-4.8-10.7-10.7S705.9 64.1 711.8 64.1z"/><path class="st0" d="M74.5 108.3c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C57.9 100.9 65.3 108.3 74.5 108.3zM74.5 81c5.9 0 10.7 4.8 10.7 10.7 0 5.9-4.8 10.7-10.7 10.7s-10.7-4.8-10.7-10.7S68.6 81 74.5 81z"/><path class="st1" d="M303 146.1c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C286.4 138.6 293.8 146.1 303 146.1zM303 118.7c5.9 0 10.7 4.8 10.7 10.7 0 5.9-4.8 10.7-10.7 10.7s-10.7-4.8-10.7-10.7C292.3 123.5 297.1 118.7 303 118.7z"/><path class="st2" d="M243.4 347.4c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7S234.2 347.4 243.4 347.4zM243.4 320c5.9 0 10.7 4.8 10.7 10.7 0 5.9-4.8 10.7-10.7 10.7s-10.7-4.8-10.7-10.7S237.5 320 243.4 320z"/><path class="st1" d="M809.8 542.3c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C793.2 534.8 800.7 542.3 809.8 542.3zM809.8 514.9c5.9 0 10.7 4.8 10.7 10.7s-4.8 10.7-10.7 10.7 -10.7-4.8-10.7-10.7S803.9 514.9 809.8 514.9z"/><path class="st3" d="M1060.5 548.3c9.2 0 16.7-7.5 16.7-16.7s-7.5-16.7-16.7-16.7 -16.7 7.5-16.7 16.7C1043.9 540.8 1051.4 548.3 1060.5 548.3zM1060.5 520.9c5.9 0 10.7 4.8 10.7 10.7s-4.8 10.7-10.7 10.7 -10.7-4.8-10.7-10.7S1054.6 520.9 1060.5 520.9z"/><path class="st3" d="M387.9 25.2l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L387.9 25.2z"/><path class="st3" d="M368.3 498.6l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L368.3 498.6z"/><path class="st3" d="M16.4 270.2l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L16.4 270.2z"/><path class="st2" d="M824.7 351.1l7.4-7.4c1.1-1.1 1.1-3 0-4.1s-3-1.1-4.1 0l-7.4 7.4 -7.4-7.4c-1.1-1.1-3-1.1-4.1 0s-1.1 3 0 4.1l7.4 7.4 -7.4 7.4c-1.1 1.1-1.1 3 0 4.1s3 1.1 4.1 0l7.4-7.4 7.4 7.4c1.1 1.1 3 1.1 4.1 0s1.1-3 0-4.1L824.7 351.1z"/><path class="st1" d="M146.3 573.6H138v-8.3c0-1.3-1-2.3-2.3-2.3s-2.3 1-2.3 2.3v8.3h-8.3c-1.3 0-2.3 1-2.3 2.3s1 2.3 2.3 2.3h8.3v8.3c0 1.3 1 2.3 2.3 2.3s2.3-1 2.3-2.3v-8.3h8.3c1.3 0 2.3-1 2.3-2.3S147.6 573.6 146.3 573.6z"/><path class="st1" d="M1005.6 76.3h-8.3V68c0-1.3-1-2.3-2.3-2.3s-2.3 1-2.3 2.3v8.3h-8.3c-1.3 0-2.3 1-2.3 2.3s1 2.3 2.3 2.3h8.3v8.3c0 1.3 1 2.3 2.3 2.3s2.3-1 2.3-2.3v-8.3h8.3c1.3 0 2.3-1 2.3-2.3S1006.8 76.3 1005.6 76.3z"/><path class="st1" d="M95.5 251.6c-3.5 0-6.3 2.8-6.3 6.3 0 3.5 2.8 6.3 6.3 6.3s6.3-2.8 6.3-6.3S99 251.6 95.5 251.6z"/><path class="st0" d="M1032 281.8c-3.5 0-6.3 2.8-6.3 6.3s2.8 6.3 6.3 6.3 6.3-2.8 6.3-6.3S1035.5 281.8 1032 281.8z"/><path class="st2" d="M741.6 139.3c-3.5 0-6.3 2.8-6.3 6.3s2.8 6.3 6.3 6.3 6.3-2.8 6.3-6.3S745 139.3 741.6 139.3z"/><path class="st3" d="M890.7 43.5c3.3 0 6-2.7 6-6s-2.7-6-6-6 -6 2.7-6 6C884.8 40.8 887.4 43.5 890.7 43.5z"/><path class="st0" d="M164.3 537.6c3.3 0 6-2.7 6-6s-2.7-6-6-6 -6 2.7-6 6C158.4 535 161 537.6 164.3 537.6z"/></svg>
							<svg xmlns="http://www.w3.org/2000/svg" fill="#607D8B" class="feather feather-lock" width="24" height="24" viewBox="0 0 24 24"><path d="M12,1A5,5 0 0,0 7,6V8H6A2,2 0 0,0 4,10V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V10A2,2 0 0,0 18,8H17V6A5,5 0 0,0 12,1M12,2.9C13.71,2.9 15.1,4.29 15.1,6V8H8.9V6C8.9,4.29 10.29,2.9 12,2.9M11,11H13V15H11V11M11,17H13V19H11V17Z" /></svg>
						</h5>
						<h4>{lang('profile_is_private')}</h4>
						<p>{lang('follow2see_profile')}</p>
					</div>
				<div class="container container-profile">	
			{else}
				<div class="fluid include">
					{include file="$content_page"}
				</div>
			{/if}
		{/if}
	</div>

	{if not $is_owner}
		<div class="modal--menu" id="report-profile">
			<div class="modal-outer">
				<div class="modal-inner">
					<h5 class="title"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-users" color="#000"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12" y2="16"></line></svg> {lang('report_user')}
					<span class="pull-right" title="{lang('cancel')}" data-modal--menu-dismiss>
						<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
					</span>
					</h5>
					<ul class="list-group">
						<li class="list-group-item" onclick="report_profile('{$user_data.user_id}',1);"><a href="javascript:void(0);">{lang('report_t1')}</a></li>
						<li class="list-group-item" onclick="report_profile('{$user_data.user_id}',2);"><a href="javascript:void(0);">{lang('report_t2')}</a></li>
						<li class="list-group-item" onclick="report_profile('{$user_data.user_id}',3);"><a href="javascript:void(0);">{lang('report_t3')}</a></li>
						<li class="list-group-item" onclick="report_profile('{$user_data.user_id}',4);"><a href="javascript:void(0);">{lang('report_t4')}</a></li>
						<li class="list-group-item" onclick="report_profile('{$user_data.user_id}',5);"><a href="javascript:void(0);">{lang('report_t5')}</a></li>
						<li class="list-group-item" onclick="report_profile('{$user_data.user_id}',6);"><a href="javascript:void(0);">{lang('report_t6')}</a></li>
						<li class="list-group-item" onclick="report_profile('{$user_data.user_id}',7);"><a href="javascript:void(0);">{lang('report_t7')}</a></li>
						<li class="list-group-item" onclick="report_profile('{$user_data.user_id}',8);"><a href="javascript:void(0);">{lang('report_t8')}</a></li>
					</ul>
				</div>
				<div class="overlay hidden">
					<div id="pp_loader"><div class="speeding_wheel"></div></div>
				</div>
			</div>
		</div>
		{include file="apps/{$config.theme}/main/templates/modals/block-user.tpl"}
		{include file="apps/{$config.theme}/main/templates/modals/unblock-user.tpl"}
	{/if}
	
	{include file="js/script.tpl" assign="script"}
	{$script|minify_js}
	
	{include file="apps/{$config.theme}/main/templates/includes/lazy-load.tpl"}
	
	{literal}<style>.user-profile-page-content .user-heading::before {background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1470 1200'%3e%3cstyle type='text/css'%3e .st0%7bfill:%238089FF;%7d .st1%7bfill:%2354CEFF;%7d .st2%7bfill:%2384CE65;%7d .st3%7bfill:%23FE60A1;%7d .st4%7bopacity:0.2;%7d .st5%7bfill:%23C5D3E3;%7d .st6%7bfill:%239BA9B8;%7d %3c/style%3e%3cpath class='st0' d='M438.7 260.5c2.1-1.5 4.4-2.2 7-2 2.8 0.2 5.2 1.4 7.2 3.4l9.7 9.7c0.1 0.1 0.2 0.3 0.2 0.4 0 0.2 0 0.3-0.1 0.5 -0.1 0.2-0.2 0.3-0.3 0.4 -0.2 0.1-0.3 0.1-0.5 0.1l-4.4-0.3 0.6 4c0 0.1 0 0.2 0 0.3 0 0.1-0.1 0.2-0.1 0.2 -0.1 0.1-0.1 0.2-0.2 0.2 -0.2 0.2-0.4 0.3-0.6 0.2l-3.9-0.6 0.6 3.9c0 0.1 0 0.3-0.1 0.4 -0.1 0.1-0.1 0.2-0.2 0.3 -0.2 0.2-0.4 0.3-0.7 0.2l-4-0.6 0.2 4.5c0 0.2-0.1 0.4-0.3 0.6 -0.1 0.1-0.2 0.1-0.2 0.2 -0.2 0.1-0.3 0.1-0.5 0.1s-0.3-0.1-0.4-0.2l-9.7-9.7c-1.4-1.4-2.4-3.1-3-4.9 -0.5-1.9-0.6-3.7-0.2-5.6 0.4-1.8 1.3-3.4 2.7-4.8C438 261 438.4 260.7 438.7 260.5zM460.1 271.2l-8.2-8.2c-1.2-1.2-2.7-2.1-4.2-2.5 -1.6-0.5-3.2-0.5-4.8-0.2 -1.6 0.4-2.9 1.1-4 2.2 -1.1 1.1-1.8 2.5-2.2 4 -0.4 1.6-0.3 3.1 0.2 4.8 0.5 1.6 1.4 3 2.5 4.2l8.2 8.2 -0.2-3.4c0-0.2 0.1-0.4 0.2-0.6 0 0 0 0 0.1-0.1s0.1-0.1 0.1-0.1c0.1-0.1 0.1-0.1 0.1-0.1 0.1 0 0.1 0 0.1 0 0.1 0 0.1 0 0.2 0 0.1 0 0.1 0 0.1 0l3.9 0.6 -0.5-4c-0.1-0.3 0.1-0.5 0.2-0.7 0.2-0.2 0.4-0.3 0.6-0.2l3.9 0.6 -0.6-3.9c0-0.1 0-0.2 0-0.4 0.1-0.1 0.1-0.2 0.2-0.3 0.2-0.2 0.4-0.3 0.6-0.3L460.1 271.2zM441.4 270.3c0.1-0.1 0.2-0.1 0.3-0.2 0.1-0.1 0.2-0.1 0.3-0.1 0.1 0 0.2 0 0.3 0 0.1 0 0.2 0 0.3 0 0.1 0 0.2 0.1 0.3 0.1 0.1 0.1 0.2 0.1 0.3 0.2 0.1 0.1 0.2 0.1 0.3 0.2 0.3 0.3 0.5 0.7 0.5 1.1s-0.2 0.8-0.5 1.1 -0.7 0.5-1.1 0.5 -0.8-0.2-1.1-0.5 -0.5-0.7-0.5-1.1c0-0.4 0.2-0.8 0.5-1.1C441.2 270.4 441.3 270.3 441.4 270.3zM447.3 264.4c0.2-0.1 0.4-0.1 0.6-0.1 0.2 0 0.4 0.1 0.6 0.1 0.2 0.1 0.4 0.2 0.5 0.4 0.3 0.3 0.5 0.7 0.5 1.1 0 0.4-0.2 0.8-0.5 1.1 -0.2 0.2-0.3 0.3-0.5 0.4 -0.2 0.1-0.4 0.1-0.6 0.1 -0.2 0-0.4-0.1-0.6-0.1 -0.2-0.1-0.4-0.2-0.5-0.4 -0.2-0.2-0.3-0.4-0.4-0.7 -0.1-0.3-0.1-0.5 0-0.8 0.1-0.3 0.2-0.5 0.4-0.7C447 264.6 447.1 264.5 447.3 264.4z'/%3e%3cpath class='st1' d='M1036 300.9c0 0.1 0 0.1 0 0.1v12c0 0.3-0.1 0.5-0.2 0.8 -0.2 0.3-0.3 0.4-0.6 0.6 -0.3 0.2-0.5 0.2-0.8 0.2H1012c-0.4 0-0.8-0.2-1.1-0.5 -0.3-0.3-0.5-0.7-0.5-1.1v-12c0-0.6 0.2-1 0.7-1.4l4.1-4.1v-2.7c0-0.2 0.1-0.4 0.2-0.5 0.2-0.2 0.3-0.2 0.5-0.2h2.7l2.9-2.5c0.2-0.2 0.4-0.3 0.6-0.4 0.2-0.1 0.5-0.2 0.7-0.2 0.3-0.1 0.5-0.1 0.8 0s0.5 0.1 0.7 0.2c0.2 0.1 0.4 0.3 0.6 0.4l2.9 2.5h2.5c0.2 0 0.4 0.1 0.5 0.2 0.2 0.2 0.2 0.3 0.2 0.5v2.6l4.2 4.2c0.1 0.1 0.1 0.1 0.2 0.2 0.1 0.1 0.1 0.1 0.1 0.2l0 0c0.1 0.1 0.1 0.1 0.1 0.2 0.1 0.1 0.1 0.1 0.1 0.2 0 0.1 0.1 0.1 0.1 0.2 0 0.1 0 0.1 0 0.2C1036 300.8 1036 300.8 1036 300.9zM1012 302.6v9.3l5.1-4.8L1012 302.6zM1012.9 300l-0.7 0.6 2.9 2.6v-5.5L1012.9 300 1012.9 300zM1013.1 313h20.2l-9.6-8.7c-0.2-0.1-0.4-0.2-0.6-0.2 -0.2 0-0.4 0.1-0.6 0.2l-3.5 3.2c0 0.1-0.1 0.1-0.1 0.1l-0.1 0.1c-0.1 0.1-0.2 0.2-0.3 0.2L1013.1 313zM1016.8 293.7v11l1.5 1.4 3.2-3c0.1-0.1 0.2-0.2 0.3-0.2 0.1-0.1 0.3-0.1 0.4-0.2 0.1-0.1 0.2-0.1 0.4-0.1 0.1-0.1 0.3-0.1 0.4-0.1 0.1 0 0.3 0 0.4 0s0.3 0.1 0.4 0.1c0.1 0.1 0.3 0.1 0.4 0.1 0.1 0.1 0.2 0.1 0.3 0.2 0.1 0.1 0.2 0.2 0.3 0.2l3.4 3.1 1.4-1.3v-11.2H1016.8zM1021.1 292.1h4.4l-1.6-1.4c-0.1-0.1-0.2-0.1-0.3-0.2 -0.1-0.1-0.2-0.1-0.3-0.1 -0.2 0-0.4 0.1-0.6 0.2L1021.1 292.1zM1034.5 311.8v-9l-5.1 4.5L1034.5 311.8zM1031.2 297.7v5.7l3-2.7 -1.4-1.4 0 0L1031.2 297.7z'/%3e%3cpath class='st2' d='M984.9 629.4c-0.1 0-0.1 0-0.2 0 -0.1 0-0.1 0-0.2 0 -0.1 0-0.1 0-0.2-0.1 -0.1 0-0.1-0.1-0.2-0.1 -0.1 0-0.1-0.1-0.2-0.1 -0.1 0-0.1-0.1-0.2-0.1 -0.1-0.1-0.1-0.1-0.2-0.1 -0.1-0.1-0.1-0.1-0.2-0.1l-10.9-11c-0.4-0.4-0.5-0.8-0.5-1.4s0.2-1 0.5-1.4l4-4c0.1-0.1 0.3-0.2 0.4-0.2 0.2-0.1 0.3 0 0.5 0.1 0.2 0.1 0.3 0.2 0.3 0.4 0.1 0.2 0.1 0.3 0.1 0.5 -0.1 0.1-0.1 0.2-0.1 0.3 0 0.1 0 0.2 0 0.3 0 0.6 0.2 1.1 0.4 1.6 0.3 0.5 0.6 0.9 1.2 1.2 0.5 0.3 1 0.4 1.6 0.4 0.9 0 1.6-0.3 2.2-0.9 0.6-0.6 0.9-1.4 0.9-2.3 0-0.4-0.1-0.9-0.2-1.2s-0.4-0.7-0.6-1c-0.3-0.3-0.6-0.5-1-0.7 -0.4-0.2-0.8-0.3-1.2-0.3 -0.2 0-0.3 0-0.6 0.1 -0.4 0.1-0.6-0.1-0.9-0.4 -0.2-0.3-0.1-0.6 0.2-0.9l3.7-3.8c0.2-0.2 0.4-0.3 0.6-0.4 0.2-0.1 0.5-0.2 0.7-0.2s0.5 0.1 0.7 0.2c0.2 0.1 0.4 0.2 0.6 0.4l2.8 2.8c0.3-0.9 0.8-1.6 1.6-2.2 0.8-0.6 1.6-0.9 2.6-0.9 0.6 0 1.2 0.1 1.7 0.3 0.5 0.2 1 0.5 1.4 0.9s0.7 0.9 0.9 1.4c0.2 0.5 0.3 1.1 0.3 1.7 0 0.4-0.1 0.8-0.2 1.1s-0.2 0.7-0.4 1c-0.2 0.3-0.4 0.6-0.6 0.9 -0.3 0.3-0.5 0.5-0.9 0.7 -0.3 0.2-0.6 0.4-1 0.5l2.7 2.7c0.4 0.4 0.5 0.8 0.5 1.4 0 0.5-0.2 1-0.5 1.4l-10.9 11C985.9 629.2 985.4 629.4 984.9 629.4zM976.5 613.7l-2.7 2.7c-0.2 0.2-0.2 0.3 0 0.4l10.9 11c0.2 0.1 0.3 0.1 0.4 0l10.9-11c0.1-0.1 0.1-0.1 0.1-0.1s0-0.1 0-0.2c0-0.1-0.1-0.1-0.1-0.2l-3.8-3.8c-0.3-0.3-0.3-0.6-0.2-0.9 0.2-0.3 0.4-0.5 0.8-0.4h0.1l0 0c0.1 0 0.2 0 0.2 0 0.8 0 1.5-0.3 2-0.8 0.5-0.5 0.8-1.2 0.8-2s-0.3-1.5-0.8-2c-0.5-0.5-1.2-0.8-2-0.8 -0.4 0-0.7 0.1-1.1 0.2 -0.3 0.2-0.6 0.3-0.9 0.6 -0.3 0.3-0.4 0.5-0.6 0.9 -0.2 0.3-0.2 0.7-0.2 1.1 0 0.1 0 0.1 0 0.2v0.2c0 0.1 0 0.2 0 0.3 -0.1 0.1-0.1 0.2-0.2 0.3 -0.1 0.1-0.2 0.2-0.3 0.2 -0.3 0.2-0.6 0.1-0.9-0.2l-4-4c-0.1-0.1-0.1-0.1-0.1-0.1s-0.1-0.1-0.1-0.1h-0.1c0 0-0.1 0-0.1 0.1 -0.1 0-0.1 0.1-0.1 0.1l-2.4 2.4c1 0.3 1.9 0.8 2.5 1.7s1 1.8 1 3c0 0.4-0.1 0.9-0.2 1.3 -0.1 0.4-0.3 0.8-0.5 1.1 -0.2 0.3-0.4 0.7-0.7 1 -0.3 0.3-0.6 0.5-0.9 0.8 -0.3 0.2-0.7 0.4-1.1 0.5 -0.4 0.1-0.8 0.2-1.2 0.2 -0.2 0-0.4 0-0.6-0.1 -0.2-0.1-0.4-0.1-0.6-0.2 -0.2-0.1-0.4-0.1-0.6-0.2 -0.2-0.1-0.4-0.2-0.5-0.3 -0.2-0.1-0.3-0.2-0.5-0.3 -0.2-0.1-0.3-0.3-0.5-0.4 -0.2-0.2-0.3-0.3-0.4-0.5 -0.1-0.2-0.2-0.4-0.3-0.5 -0.1-0.2-0.2-0.4-0.3-0.5C976.6 614.1 976.5 613.9 976.5 613.7z'/%3e%3cpath class='st3' d='M414.6 639.8c-0.1 0-0.2 0-0.3 0 -0.1 0-0.2 0-0.3 0 -0.1 0-0.2 0-0.3 0 -0.1 0-0.2 0-0.3 0 -0.1 0-0.2-0.1-0.3-0.1 -0.1 0.2-0.4 0.4-0.8 0.7 -0.4 0.3-0.9 0.6-1.4 1 -0.5 0.3-1.1 0.6-1.7 1 -0.6 0.3-1.2 0.5-1.6 0.5l0 0c-0.1 0-0.1 0-0.2 0 -0.1 0-0.1 0-0.2 0 -0.1 0-0.1-0.1-0.1-0.1 -0.1 0-0.1-0.1-0.1-0.1 -0.1 0-0.1-0.1-0.1-0.1 0-0.1-0.1-0.1-0.1-0.1s-0.1-0.1-0.1-0.1c0-0.1 0-0.1 0-0.2 0-0.1 0-0.2 0.1-0.2l0 0c0.9-1.6 1.4-2.7 1.4-3.5v-0.1c-1.3-0.6-2.3-1.6-3-2.9 -0.7-1.3-1-2.7-1-4.1s0.5-2.8 1.4-4 2.2-2.2 3.8-2.9c1.6-0.7 3.4-1 5.3-1 0.7 0 1.4 0.1 2.1 0.2 0.7 0.1 1.4 0.3 1.9 0.4 0.6 0.2 1.2 0.4 1.8 0.7 0.5 0.3 1.1 0.6 1.5 1 0.4 0.3 0.9 0.8 1.2 1.1 0.4 0.4 0.7 0.9 1 1.4 0.3 0.5 0.4 1 0.6 1.5 0.2 0.5 0.2 1 0.2 1.6 0 1.6-0.4 3-1.3 4.3 -0.9 1.2-2.1 2.2-3.7 2.9 -1.6 0.7-3.3 1-5.2 1C414.8 639.8 414.7 639.8 414.6 639.8zM413.4 638.1c0.5 0.1 1 0.1 1.5 0.1 1.2 0 2.3-0.2 3.4-0.5 1.1-0.3 1.9-0.8 2.7-1.4 0.8-0.6 1.4-1.3 1.8-2.1 0.4-0.8 0.6-1.7 0.6-2.7 0-1.1-0.4-2.2-1.2-3.1 -0.8-1-1.8-1.7-3.2-2.3s-2.8-0.8-4.4-0.8 -3.1 0.3-4.4 0.8 -2.4 1.3-3.2 2.3c-0.8 1-1.2 2-1.2 3.1s0.3 2.2 0.8 3.2c0.5 1 1.4 1.8 2.4 2.3l0.9 0.4 -0.1 1v0.2c0 0.1-0.1 0.3-0.2 0.6 -0.1 0.3-0.2 0.8-0.4 1.2 0.4-0.3 0.9-0.5 1.3-0.9 0.4-0.4 0.8-0.6 0.9-0.8l1-0.9L413.4 638.1zM426.4 643.4L426.4 643.4c0 0.3 0.1 0.6 0.1 0.9 0.1 0.3 0.1 0.6 0.2 0.9 0.1 0.3 0.2 0.6 0.3 0.9 0.1 0.3 0.2 0.5 0.3 0.6 0.1 0.1 0.1 0.1 0.1 0.2 0 0.2-0.1 0.3-0.2 0.4 -0.1 0.1-0.2 0.2-0.4 0.2h-0.1c-0.1 0-0.1 0-0.1 0 -0.8-0.1-1.6-0.5-2.4-1.2 -0.9-0.6-1.5-1.2-1.9-1.6 -0.3 0.1-0.6 0.1-1 0.1 -0.1 0-0.1 0-0.2 0 -0.1 0-0.1 0-0.2 0 -0.1 0-0.1 0-0.2 0 -0.6 0-1.3-0.1-1.9-0.2s-1.2-0.2-1.7-0.4c-0.5-0.2-1-0.4-1.5-0.6s-0.9-0.5-1.3-0.9 -0.8-0.7-1.1-1.1l0 0h2.3c1.4 1 3.1 1.6 5.1 1.6h0.2c0.2 0 0.3 0 0.5 0 0.2 0 0.3 0 0.4-0.1l0.9-0.1 0.1 0.1c0.1 0.1 0.1 0.2 0.2 0.3 0.1 0.1 0.2 0.3 0.4 0.4 0.2 0.2 0.3 0.4 0.6 0.6s0.5 0.4 0.8 0.6c-0.1-0.3-0.2-1.2-0.2-2.6l0.8-0.4c0.5-0.3 0.9-0.5 1.2-0.8s0.6-0.6 0.9-0.9c0.2-0.3 0.4-0.7 0.5-1 0.1-0.4 0.2-0.8 0.2-1.2 0-0.8-0.1-1.4-0.4-1.9 -0.3-0.5-0.7-1-1.4-1.5 0.2-0.6 0.3-1.2 0.4-1.7 1.9 1.1 3 2.9 3 5.1C429.9 640.4 428.8 642.2 426.4 643.4z'/%3e%3cg class='st4'%3e%3cpath class='st5' d='M949.7 201c4 0 7.2-3.2 7.2-7.2 0-4-3.2-7.2-7.2-7.2 -4 0-7.2 3.2-7.2 7.2C942.5 197.7 945.7 201 949.7 201zM949.7 189.1c2.6 0 4.7 2.1 4.7 4.7s-2.1 4.7-4.7 4.7c-2.6 0-4.7-2.1-4.7-4.7C945.1 191.2 947.1 189.1 949.7 189.1z'/%3e%3cpath class='st5' d='M1272.7 392c4 0 7.2-3.2 7.2-7.2s-3.2-7.2-7.2-7.2c-4 0-7.2 3.2-7.2 7.2C1265.6 388.7 1268.8 392 1272.7 392zM1272.7 380.1c2.6 0 4.7 2.1 4.7 4.7s-2.1 4.7-4.7 4.7 -4.7-2.1-4.7-4.7C1268.1 382.2 1270.1 380.1 1272.7 380.1z'/%3e%3cpath class='st5' d='M1431.5 581.4c4 0 7.2-3.2 7.2-7.2 0-4-3.2-7.2-7.2-7.2s-7.2 3.2-7.2 7.2C1424.4 578.2 1427.7 581.4 1431.5 581.4zM1431.5 569.6c2.6 0 4.7 2.1 4.7 4.7s-2.1 4.7-4.7 4.7 -4.7-2.1-4.7-4.7C1427 571.6 1429.1 569.6 1431.5 569.6z'/%3e%3cpath class='st5' d='M515.1 357.5c4 0 7.2-3.2 7.2-7.2 0-4-3.2-7.2-7.2-7.2 -4 0-7.2 3.2-7.2 7.2C507.9 354.3 511.2 357.5 515.1 357.5zM515.1 345.7c2.6 0 4.7 2.1 4.7 4.7 0 2.6-2.1 4.7-4.7 4.7 -2.6 0-4.7-2.1-4.7-4.7C510.5 347.7 512.6 345.7 515.1 345.7z'/%3e%3cpath class='st5' d='M583.8 896.5c4 0 7.2-3.2 7.2-7.2 0-4-3.2-7.2-7.2-7.2 -4 0-7.2 3.2-7.2 7.2C576.7 893.2 579.9 896.5 583.8 896.5zM583.8 884.6c2.6 0 4.7 2.1 4.7 4.7 0 2.6-2.1 4.7-4.7 4.7s-4.7-2.1-4.7-4.7C579.2 886.7 581.3 884.6 583.8 884.6z'/%3e%3cpath class='st5' d='M377.1 601.9c4 0 7.2-3.2 7.2-7.2 0-4-3.2-7.2-7.2-7.2 -4 0-7.2 3.2-7.2 7.2C369.9 598.6 373.2 601.9 377.1 601.9zM377.1 590.1c2.6 0 4.7 2.1 4.7 4.7 0 2.6-2.1 4.7-4.7 4.7 -2.6 0-4.7-2.1-4.7-4.7C372.5 592.2 374.6 590.1 377.1 590.1z'/%3e%3cpath class='st5' d='M33.5 631c4 0 7.2-3.2 7.2-7.2s-3.2-7.2-7.2-7.2c-4 0-7.2 3.2-7.2 7.2C26.2 627.7 29.5 631 33.5 631zM33.5 619.1c2.6 0 4.7 2.1 4.7 4.7s-2.1 4.7-4.7 4.7c-2.6 0-4.7-2.1-4.7-4.7C28.9 621.2 30.9 619.1 33.5 619.1z'/%3e%3cpath class='st5' d='M637.2 236.5c4 0 7.2-3.2 7.2-7.2 0-4-3.2-7.2-7.2-7.2 -4 0-7.2 3.2-7.2 7.2C629.9 233.2 633.2 236.5 637.2 236.5zM637.2 224.6c2.6 0 4.7 2.1 4.7 4.7 0 2.6-2.1 4.7-4.7 4.7s-4.7-2.1-4.7-4.7C632.5 226.7 634.6 224.6 637.2 224.6z'/%3e%3cpath class='st5' d='M1380.4 819.9c4 0 7.2-3.2 7.2-7.2s-3.2-7.2-7.2-7.2c-4 0-7.2 3.2-7.2 7.2C1373.2 816.6 1376.4 819.9 1380.4 819.9zM1380.4 808c2.6 0 4.7 2.1 4.7 4.7 0 2.6-2.1 4.7-4.7 4.7s-4.7-2.1-4.7-4.7S1377.8 808 1380.4 808z'/%3e%3cpath class='st5' d='M649.1 981.2c4 0 7.2-3.2 7.2-7.2 0-4-3.2-7.2-7.2-7.2s-7.2 3.2-7.2 7.2C641.9 977.9 645.1 981.2 649.1 981.2zM649.1 969.3c2.6 0 4.7 2.1 4.7 4.7 0 2.6-2.1 4.7-4.7 4.7 -2.6 0-4.7-2.1-4.7-4.7S646.5 969.3 649.1 969.3z'/%3e%3cpath class='st5' d='M1186.9 1027.1c4 0 7.2-3.2 7.2-7.2s-3.2-7.2-7.2-7.2c-4 0-7.2 3.2-7.2 7.2C1179.7 1023.8 1183 1027.1 1186.9 1027.1zM1186.9 1015.2c2.6 0 4.7 2.1 4.7 4.7s-2.1 4.7-4.7 4.7 -4.7-2.1-4.7-4.7S1184.4 1015.2 1186.9 1015.2z'/%3e%3cpath class='st5' d='M1192.7 756.4c4 0 7.2-3.2 7.2-7.2s-3.2-7.2-7.2-7.2c-4 0-7.2 3.2-7.2 7.2C1185.5 753.1 1188.7 756.4 1192.7 756.4zM1192.7 744.5c2.6 0 4.7 2.1 4.7 4.7s-2.1 4.7-4.7 4.7 -4.7-2.1-4.7-4.7S1190.1 744.5 1192.7 744.5z'/%3e%3cpath class='st5' d='M1037.1 926.4c4 0 7.2-3.2 7.2-7.2s-3.2-7.2-7.2-7.2c-4 0-7.2 3.2-7.2 7.2C1029.9 923.1 1033.2 926.4 1037.1 926.4zM1037.1 914.5c2.6 0 4.7 2.1 4.7 4.7s-2.1 4.7-4.7 4.7 -4.7-2.1-4.7-4.7S1034.5 914.5 1037.1 914.5z'/%3e%3cpath class='st5' d='M1261.6 557.5c4 0 7.2-3.2 7.2-7.2s-3.2-7.2-7.2-7.2c-4 0-7.2 3.2-7.2 7.2C1254.4 554.2 1257.6 557.5 1261.6 557.5zM1261.6 545.6c2.6 0 4.7 2.1 4.7 4.7 0 2.6-2.1 4.7-4.7 4.7s-4.7-2.1-4.7-4.7C1256.9 547.7 1259 545.6 1261.6 545.6z'/%3e%3cpath class='st5' d='M1045.6 120.1c4 0 7.2-3.2 7.2-7.2 0-4-3.2-7.2-7.2-7.2 -4 0-7.2 3.2-7.2 7.2C1038.4 116.8 1041.6 120.1 1045.6 120.1zM1045.6 108.3c2.6 0 4.7 2.1 4.7 4.7 0 2.6-2.1 4.7-4.7 4.7s-4.7-2.1-4.7-4.7C1040.9 110.4 1043 108.3 1045.6 108.3z'/%3e%3cpath class='st5' d='M999.4 756.4l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8 -0.5-0.5-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0s-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8s1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0 0.5-0.5 0.5-1.3 0-1.8L999.4 756.4z'/%3e%3cpath class='st5' d='M723.1 159h4.5c0.7 0 1.2-0.6 1.2-1.2 0-0.7-0.6-1.2-1.2-1.2h-4.5V152c0-0.7-0.6-1.2-1.2-1.2s-1.2 0.6-1.2 1.2v4.5h-4.5c-0.7 0-1.2 0.6-1.2 1.2s0.6 1.2 1.2 1.2h4.5v4.5c0 0.7 0.6 1.2 1.2 1.2 0.7 0 1.2-0.6 1.2-1.2L723.1 159 723.1 159z'/%3e%3cpath class='st5' d='M1125.6 240h4.5c0.7 0 1.2-0.6 1.2-1.2s-0.6-1.2-1.2-1.2h-4.5v-4.5c0-0.7-0.6-1.2-1.2-1.2s-1.2 0.6-1.2 1.2v4.5h-4.5c-0.7 0-1.2 0.6-1.2 1.2s0.6 1.2 1.2 1.2h4.5v4.5c0 0.7 0.6 1.2 1.2 1.2s1.2-0.6 1.2-1.2V240L1125.6 240z'/%3e%3cpath class='st5' d='M243 486.2h4.5c0.7 0 1.2-0.6 1.2-1.2 0-0.7-0.6-1.2-1.2-1.2H243v-4.5c0-0.7-0.6-1.2-1.2-1.2 -0.7 0-1.2 0.6-1.2 1.2v4.5H236c-0.7 0-1.2 0.6-1.2 1.2 0 0.7 0.6 1.2 1.2 1.2h4.5v4.5c0 0.7 0.6 1.2 1.2 1.2s1.2-0.6 1.2-1.2L243 486.2 243 486.2z'/%3e%3cpath class='st5' d='M353.6 237.5h4.5c0.7 0 1.2-0.6 1.2-1.2s-0.6-1.2-1.2-1.2h-4.5v-4.5c0-0.7-0.6-1.2-1.2-1.2s-1.2 0.6-1.2 1.2v4.5h-4.5c-0.7 0-1.2 0.6-1.2 1.2 0 0.7 0.6 1.2 1.2 1.2h4.5v4.5c0 0.7 0.6 1.2 1.2 1.2 0.7 0 1.2-0.6 1.2-1.2L353.6 237.5 353.6 237.5z'/%3e%3cpath class='st5' d='M523.6 128.5h4.5c0.7 0 1.2-0.6 1.2-1.2 0-0.7-0.6-1.2-1.2-1.2h-4.5v-4.5c0-0.7-0.6-1.2-1.2-1.2s-1.2 0.6-1.2 1.2v4.5h-4.5c-0.7 0-1.2 0.6-1.2 1.2 0 0.7 0.6 1.2 1.2 1.2h4.5v4.5c0 0.7 0.6 1.2 1.2 1.2 0.7 0 1.2-0.6 1.2-1.2L523.6 128.5 523.6 128.5z'/%3e%3cpath class='st5' d='M502.6 919.2l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8s-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0 -0.5 0.5-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8 0.5 0.5 1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0s0.5-1.3 0-1.8L502.6 919.2z'/%3e%3cpath class='st5' d='M810 1088.8l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8 -0.5-0.5-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0 -0.5 0.5-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8 0.5 0.5 1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0 0.5-0.5 0.5-1.3 0-1.8L810 1088.8z'/%3e%3cpath class='st5' d='M922.3 914.5l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8s-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0s-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8 0.5 0.5 1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0 0.5-0.5 0.5-1.3 0-1.8L922.3 914.5z'/%3e%3cpath class='st5' d='M1288 919.2l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8 -0.5-0.5-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0 -0.5 0.5-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8 0.5 0.5 1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0 0.5-0.5 0.5-1.3 0-1.8L1288 919.2z'/%3e%3cpath class='st5' d='M1050.3 426.1l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8 -0.5-0.5-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0 -0.5 0.5-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8 0.5 0.5 1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0 0.5-0.5 0.5-1.3 0-1.8L1050.3 426.1z'/%3e%3cpath class='st5' d='M359.4 891.6l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8s-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0s-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8s1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0s0.5-1.3 0-1.8L359.4 891.6z'/%3e%3cpath class='st5' d='M138.9 668.4l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8s-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0 -0.5 0.5-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8 0.5 0.5 1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0s0.5-1.3 0-1.8L138.9 668.4z'/%3e%3cpath class='st5' d='M1331.1 277.8l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8 -0.5-0.5-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0 -0.5 0.5-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8 0.5 0.5 1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0 0.5-0.5 0.5-1.3 0-1.8L1331.1 277.8z'/%3e%3cpath class='st5' d='M1377.5 459.3l3.2-3.2c0.5-0.5 0.5-1.3 0-1.8 -0.5-0.5-1.3-0.5-1.8 0l-3.2 3.2 -3.2-3.2c-0.5-0.5-1.3-0.5-1.8 0 -0.5 0.5-0.5 1.3 0 1.8l3.2 3.2 -3.2 3.2c-0.5 0.5-0.5 1.3 0 1.8 0.5 0.5 1.3 0.5 1.8 0l3.2-3.2 3.2 3.2c0.5 0.5 1.3 0.5 1.8 0 0.5-0.5 0.5-1.3 0-1.8L1377.5 459.3z'/%3e%3cpath class='st5' d='M1145.3 885.8h4.5c0.7 0 1.2-0.6 1.2-1.2s-0.6-1.2-1.2-1.2h-4.5v-4.5c0-0.7-0.6-1.2-1.2-1.2s-1.2 0.6-1.2 1.2v4.5h-4.5c-0.7 0-1.2 0.6-1.2 1.2s0.6 1.2 1.2 1.2h4.5v4.5c0 0.7 0.6 1.2 1.2 1.2s1.2-0.6 1.2-1.2V885.8z'/%3e%3cpath class='st5' d='M165.6 920.4h4.5c0.7 0 1.2-0.6 1.2-1.2s-0.6-1.2-1.2-1.2h-4.5v-4.5c0-0.7-0.6-1.2-1.2-1.2s-1.2 0.6-1.2 1.2v4.5h-4.5c-0.7 0-1.2 0.6-1.2 1.2s0.6 1.2 1.2 1.2h4.5v4.5c0 0.7 0.6 1.2 1.2 1.2s1.2-0.6 1.2-1.2V920.4z'/%3e%3cpath class='st5' d='M1072 1003h4.5c0.7 0 1.2-0.6 1.2-1.2s-0.6-1.2-1.2-1.2h-4.5V996c0-0.7-0.6-1.2-1.2-1.2s-1.2 0.6-1.2 1.2v4.5h-4.5c-0.7 0-1.2 0.6-1.2 1.2s0.6 1.2 1.2 1.2h4.5v4.5c0 0.7 0.6 1.2 1.2 1.2s1.2-0.6 1.2-1.2V1003z'/%3e%3cpath class='st5' d='M629.5 1077.7h4.5c0.7 0 1.2-0.6 1.2-1.2s-0.6-1.2-1.2-1.2h-4.5v-4.5c0-0.7-0.6-1.2-1.2-1.2s-1.2 0.6-1.2 1.2v4.5h-4.5c-0.7 0-1.2 0.6-1.2 1.2s0.6 1.2 1.2 1.2h4.5v4.5c0 0.7 0.6 1.2 1.2 1.2s1.2-0.6 1.2-1.2V1077.7z'/%3e%3cpath class='st5' d='M290.5 804.9h-3.6v-3.6c0-0.6-0.5-1-1-1 -0.5 0-1 0.5-1 1v3.6h-3.6c-0.6 0-1 0.5-1 1s0.5 1 1 1h3.6v3.6c0 0.6 0.5 1 1 1 0.5 0 1-0.5 1-1v-3.6h3.6c0.6 0 1-0.5 1-1S291.1 804.9 290.5 804.9z'/%3e%3cpath class='st5' d='M1271.7 465.3h-3.6v-3.6c0-0.6-0.5-1-1-1 -0.6 0-1 0.5-1 1v3.6h-3.6c-0.6 0-1 0.5-1 1s0.5 1 1 1h3.6v3.6c0 0.6 0.5 1 1 1 0.6 0 1-0.5 1-1v-3.6h3.6c0.6 0 1-0.5 1-1S1272.2 465.3 1271.7 465.3z'/%3e%3cpath class='st5' d='M1187.5 532.4h-3.6v-3.6c0-0.6-0.5-1-1-1 -0.6 0-1 0.5-1 1v3.6h-3.6c-0.6 0-1 0.5-1 1 0 0.5 0.5 1 1 1h3.6v3.6c0 0.6 0.5 1 1 1 0.6 0 1-0.5 1-1v-3.6h3.6c0.6 0 1-0.5 1-1C1188.5 532.8 1188 532.4 1187.5 532.4z'/%3e%3cpath class='st5' d='M1358.1 672.7h-3.6v-3.6c0-0.6-0.5-1-1-1s-1 0.5-1 1v3.6h-3.6c-0.6 0-1 0.5-1 1 0 0.5 0.5 1 1 1h3.6v3.6c0 0.6 0.5 1 1 1s1-0.5 1-1v-3.6h3.6c0.6 0 1-0.5 1-1C1359 673.2 1358.6 672.7 1358.1 672.7z'/%3e%3cpath class='st5' d='M1181.2 608.6l-2.6-2.6 2.6-2.6c0.4-0.4 0.4-1 0-1.4s-1-0.4-1.4 0l-2.6 2.6 -2.6-2.6c-0.4-0.4-1-0.4-1.4 0s-0.4 1 0 1.4l2.6 2.6 -2.6 2.6c-0.4 0.4-0.4 1 0 1.4s1 0.4 1.4 0l2.6-2.6 2.6 2.6c0.4 0.4 1 0.4 1.4 0S1181.6 608.9 1181.2 608.6z'/%3e%3cpath class='st5' d='M417.1 536.2c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8s2.8-1.2 2.8-2.8C419.8 537.4 418.6 536.2 417.1 536.2z'/%3e%3cpath class='st5' d='M119.1 809.5c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8s2.8-1.2 2.8-2.8C121.8 810.7 120.6 809.5 119.1 809.5z'/%3e%3cpath class='st5' d='M87.6 521.8c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8s2.8-1.2 2.8-2.8C90.4 523 89.1 521.8 87.6 521.8z'/%3e%3cpath class='st5' d='M357.6 975.9c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8s2.8-1.2 2.8-2.8C360.4 977.1 359.1 975.9 357.6 975.9z'/%3e%3cpath class='st5' d='M164.4 334.5c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8s2.8-1.2 2.8-2.8C167.1 335.8 165.9 334.5 164.4 334.5z'/%3e%3cpath class='st5' d='M1070.8 578.6c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C1073.5 579.8 1072.3 578.6 1070.8 578.6z'/%3e%3cpath class='st5' d='M1256.8 641.9c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C1259.5 643.1 1258.3 641.9 1256.8 641.9z'/%3e%3cpath class='st5' d='M1161.3 311.7c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C1164 312.9 1162.8 311.7 1161.3 311.7z'/%3e%3cpath class='st5' d='M1097.3 686.3c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8S1098.9 686.3 1097.3 686.3z'/%3e%3cpath class='st5' d='M975.9 992c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C978.7 993.2 977.5 992 975.9 992z'/%3e%3cpath class='st5' d='M1265.2 317.2c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C1268 318.4 1266.8 317.2 1265.2 317.2z'/%3e%3cpath class='st5' d='M987.6 314.5c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8s2.8-1.2 2.8-2.8C990.4 315.7 989.2 314.5 987.6 314.5z'/%3e%3cpath class='st5' d='M1151.1 392.9c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.6 0 2.8-1.2 2.8-2.8C1153.8 394.2 1152.6 392.9 1151.1 392.9z'/%3e%3cpath class='st5' d='M889.3 127.2c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8s2.8-1.2 2.8-2.8C892.1 128.5 890.9 127.2 889.3 127.2z'/%3e%3cpath class='st5' d='M686.5 849.6c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C689.2 850.9 688 849.6 686.5 849.6z'/%3e%3cpath class='st5' d='M562.8 1004.4c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C565.5 1005.7 564.3 1004.4 562.8 1004.4z'/%3e%3cpath class='st5' d='M824.8 1007.2c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C827.5 1008.4 826.3 1007.2 824.8 1007.2z'/%3e%3cpath class='st5' d='M689.3 1045.2c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C692 1046.5 690.8 1045.2 689.3 1045.2z'/%3e%3cpath class='st5' d='M794.3 896.5c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C797.1 897.6 795.8 896.5 794.3 896.5z'/%3e%3cpath class='st5' d='M1220.1 867.7c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8S1221.6 867.7 1220.1 867.7z'/%3e%3cpath class='st5' d='M579.2 771c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8s2.8-1.2 2.8-2.8C581.9 772.1 580.7 771 579.2 771z'/%3e%3cpath class='st5' d='M425.1 408.1c-1.5 0-2.8 1.2-2.8 2.8 0 1.6 1.2 2.8 2.8 2.8 1.5 0 2.8-1.2 2.8-2.8C427.9 409.3 426.6 408.1 425.1 408.1z'/%3e%3cpath class='st5' d='M645.5 309c-1.5 0-2.8 1.2-2.8 2.8 0 1.5 1.2 2.8 2.8 2.8s2.8-1.2 2.8-2.8C648.2 310.2 647 309 645.5 309z'/%3e%3cpath class='st5' d='M390.3 155.9c-1 3.9 1.3 7.8 5.2 8.8 3.9 1 7.8-1.3 8.8-5.2 1-3.9-1.3-7.8-5.2-8.8C395.2 149.8 391.3 152.1 390.3 155.9zM401.7 158.9c-0.6 2.5-3.2 4-5.7 3.3 -2.5-0.6-4-3.2-3.3-5.7s3.2-4 5.7-3.3C400.9 153.9 402.4 156.5 401.7 158.9z'/%3e%3cpath class='st5' d='M766.9 86.7c-1 3.9 1.3 7.8 5.2 8.8 3.9 1 7.8-1.3 8.8-5.2 1-3.9-1.3-7.8-5.2-8.8C771.9 80.6 767.9 82.9 766.9 86.7zM778.4 89.7c-0.6 2.5-3.2 4-5.7 3.3s-4-3.2-3.3-5.7c0.6-2.5 3.2-4 5.7-3.3C777.6 84.7 779 87.3 778.4 89.7z'/%3e%3cpath class='st5' d='M124.8 437.6c-1 3.9 1.3 7.8 5.2 8.8 3.9 1 7.8-1.3 8.8-5.2s-1.3-7.8-5.2-8.8C129.8 431.5 125.8 433.8 124.8 437.6zM136.3 440.6c-0.6 2.5-3.2 4-5.7 3.3 -2.5-0.6-4-3.2-3.3-5.7 0.6-2.5 3.2-4 5.7-3.3C135.4 435.7 136.9 438.2 136.3 440.6z'/%3e%3cpath class='st5' d='M206.6 740.1c-1 3.9 1.3 7.8 5.2 8.8 3.9 1 7.8-1.3 8.8-5.2s-1.3-7.8-5.2-8.8C211.6 734 207.6 736.3 206.6 740.1zM218.1 743.1c-0.6 2.5-3.2 4-5.7 3.3 -2.5-0.6-4-3.2-3.3-5.7 0.6-2.5 3.2-4 5.7-3.3C217.2 738.1 218.8 740.6 218.1 743.1z'/%3e%3cpath class='st5' d='M403.1 331l2.3 3.9c0.3 0.6 1.2 0.8 1.7 0.4 0.6-0.3 0.8-1.2 0.4-1.7l-2.3-3.9 3.9-2.3c0.6-0.3 0.8-1.2 0.4-1.7 -0.3-0.6-1.2-0.8-1.7-0.4l-3.9 2.3 -2.3-3.9c-0.3-0.6-1.2-0.8-1.7-0.4 -0.6 0.3-0.8 1.2-0.4 1.7l2.3 3.9 -3.9 2.3c-0.6 0.3-0.8 1.2-0.4 1.7 0.3 0.6 1.2 0.8 1.7 0.4L403.1 331z'/%3e%3cpath class='st5' d='M208.5 256.3l2.3 3.9c0.3 0.6 1.2 0.8 1.7 0.4 0.6-0.3 0.8-1.2 0.4-1.7l-2.3-3.9 3.9-2.3c0.6-0.3 0.8-1.2 0.4-1.7 -0.3-0.6-1.2-0.8-1.7-0.4l-3.9 2.3 -2.3-3.9c-0.3-0.6-1.2-0.8-1.7-0.4 -0.6 0.3-0.8 1.2-0.4 1.7l2.3 3.9 -3.9 2.3c-0.6 0.3-0.8 1.2-0.4 1.7 0.3 0.6 1.2 0.8 1.7 0.4L208.5 256.3z'/%3e%3cpath class='st5' d='M1021.8 226l-0.6 4.5c-0.1 0.6 0.4 1.3 1.1 1.4s1.3-0.4 1.4-1.1l0.6-4.5 4.5 0.6c0.6 0.1 1.3-0.4 1.4-1.1s-0.4-1.3-1.1-1.4l-4.5-0.6 0.6-4.5c0.1-0.6-0.4-1.3-1.1-1.4 -0.6-0.1-1.3 0.4-1.4 1.1l-0.6 4.5 -4.5-0.6c-0.6-0.1-1.3 0.4-1.4 1.1 -0.1 0.6 0.4 1.3 1.1 1.4L1021.8 226z'/%3e%3cpath class='st5' d='M1277.8 777.5l-0.6 4.5c-0.1 0.6 0.4 1.3 1.1 1.4s1.3-0.4 1.4-1.1l0.6-4.5 4.5 0.6c0.6 0.1 1.3-0.4 1.4-1.1 0.1-0.6-0.4-1.3-1.1-1.4l-4.5-0.6 0.6-4.5c0.1-0.6-0.4-1.3-1.1-1.4 -0.6-0.1-1.3 0.4-1.4 1.1l-0.6 4.5 -4.5-0.6c-0.6-0.1-1.3 0.4-1.4 1.1 -0.1 0.6 0.4 1.3 1.1 1.4L1277.8 777.5z'/%3e%3cpath class='st5' d='M536.9 197.2c0.4-1.5-0.4-3-2-3.4 -1.5-0.4-3 0.4-3.4 2 -0.4 1.5 0.4 3 2 3.4C535 199.5 536.5 198.7 536.9 197.2z'/%3e%3cpath class='st5' d='M642.6 116.4c0.4-1.5-0.4-3-2-3.4 -1.5-0.4-3 0.4-3.4 2s0.4 3 2 3.4C640.7 118.6 642.2 117.8 642.6 116.4z'/%3e%3cpath class='st5' d='M306.3 408.8c0.4-1.5-0.4-3-2-3.4 -1.5-0.4-3 0.4-3.4 2 -0.4 1.5 0.4 3 2 3.4C304.5 411.2 306 410.2 306.3 408.8z'/%3e%3cpath class='st5' d='M454.2 244.2c0.4-1.5-0.4-3-2-3.4 -1.5-0.4-3 0.4-3.4 2 -0.4 1.5 0.4 3 2 3.4C452.3 246.5 453.8 245.6 454.2 244.2z'/%3e%3cpath class='st5' d='M903.4 37.2c0.4-1.5-0.4-3-2-3.4 -1.5-0.4-3 0.4-3.4 2 -0.4 1.5 0.4 3 2 3.4C901.5 39.5 903 38.6 903.4 37.2z'/%3e%3cpath class='st5' d='M903.5 319.9c1.4 0 2.6-1.2 2.6-2.6 0-1.4-1.2-2.6-2.6-2.6 -1.4 0-2.6 1.2-2.6 2.6C901 318.7 902.1 319.9 903.5 319.9z'/%3e%3cpath class='st5' d='M412 733.2c1.4 0 2.6-1.2 2.6-2.6s-1.2-2.6-2.6-2.6 -2.6 1.2-2.6 2.6C409.4 732.1 410.5 733.2 412 733.2z'/%3e%3cpath class='st5' d='M990.3 862.5c1.4 0 2.6-1.2 2.6-2.6s-1.2-2.6-2.6-2.6 -2.6 1.2-2.6 2.6C987.7 861.4 988.8 862.5 990.3 862.5z'/%3e%3cpath class='st5' d='M1114.7 817.9c1.4 0 2.6-1.2 2.6-2.6s-1.2-2.6-2.6-2.6 -2.6 1.2-2.6 2.6C1112.2 816.8 1113.3 817.9 1114.7 817.9z'/%3e%3cpath class='st5' d='M834.2 301.8c-1.4 0-2.6-0.5-3.6-1.6 -1.1-1.1-1.6-2.5-1.6-4.1 0-1.6 0.5-3 1.6-4.1l17.4-18.6c0.9-0.9 1.9-1.5 3.1-1.8 1.2-0.3 2.4-0.2 3.5 0.2 1.2 0.4 2.3 1.1 3.3 2.1 0.3 0.3 0.7 0.7 0.9 1.1s0.5 0.9 0.7 1.3c0.2 0.5 0.3 0.9 0.4 1.4 0.1 0.5 0.1 1 0.1 1.5 -0.1 2.2-0.8 3.9-2.2 5.4l-13.2 14c-0.2 0.2-0.4 0.3-0.7 0.3s-0.5-0.1-0.7-0.3c-0.2-0.2-0.3-0.4-0.3-0.7 0-0.3 0.1-0.5 0.3-0.7l13.2-14c1-1.1 1.6-2.4 1.6-4.1s-0.5-3-1.6-4c-0.7-0.7-1.4-1.2-2.2-1.5 -0.8-0.3-1.6-0.5-2.6-0.3s-1.7 0.5-2.4 1.2l-17.4 18.6c-0.7 0.7-1.1 1.6-1.1 2.7 0 1 0.4 2 1.1 2.7 0.3 0.3 0.7 0.6 1.1 0.8 0.4 0.2 0.9 0.3 1.2 0.2 0.9-0.1 1.7-0.5 2.5-1.2l13.9-14.8c0.1-0.1 0.2-0.2 0.3-0.3 0.1-0.1 0.2-0.3 0.3-0.4 0.1-0.1 0.2-0.3 0.3-0.5 0.1-0.2 0.1-0.3 0.1-0.5s0-0.3-0.1-0.5c-0.1-0.2-0.2-0.3-0.4-0.5 -0.4-0.4-0.8-0.6-1.1-0.5 -0.4 0.1-0.9 0.3-1.3 0.8l-10.4 11.1c-0.1 0.1-0.3 0.2-0.4 0.3 -0.1 0.1-0.3 0.1-0.5 0s-0.3-0.1-0.5-0.3c-0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5 0.3-0.7l10.4-11.1c0.9-0.8 1.6-1.2 2.5-1.3 1-0.1 1.8 0.3 2.7 1.1 0.8 0.7 1.1 1.6 1 2.6 -0.1 1-0.6 2-1.4 2.9l-13.9 14.7c-1.1 1.1-2.4 1.8-3.8 1.8 -0.1 0-0.1 0-0.1 0C834.3 301.8 834.2 301.8 834.2 301.8z'/%3e%3cpath class='st5' d='M476.7 837.9c0.2 0.1 0.4 0.3 0.5 0.5 0.1 0.2 0.2 0.5 0.2 0.7v16.6c0 0.4-0.1 0.7-0.4 1 -0.3 0.3-0.6 0.4-1 0.4h-20.2c-0.4 0-0.7-0.1-1-0.4 -0.3-0.3-0.4-0.6-0.4-1v-16.6c0-0.4 0.1-0.7 0.4-1 0.3-0.3 0.6-0.4 1-0.4H476C476.2 837.7 476.5 837.8 476.7 837.9zM476 839.2h-20.2v10.3l5.3-5.1c0.1-0.1 0.3-0.2 0.5-0.2s0.4 0.1 0.5 0.3l5.9 5.9 2.7-2.4c0.1-0.1 0.3-0.2 0.5-0.1 0.2 0 0.3 0.1 0.5 0.2l4.2 4.3L476 839.2 476 839.2zM476 854.4C475.9 854.4 475.9 854.4 476 854.4l-4.8-5 -2.6 2.4c-0.1 0.1-0.3 0.2-0.5 0.2s-0.3 0-0.5-0.2l-6-5.9 -5.8 5.6v4.2h20.2L476 854.4 476 854.4zM469.9 844.5c-0.3-0.3-0.4-0.6-0.4-1s0.1-0.7 0.4-1c0.3-0.3 0.6-0.4 1-0.4 0.4 0 0.7 0.1 1 0.4 0.3 0.3 0.4 0.6 0.4 1 0 0.3 0 0.5-0.2 0.7 -0.1 0.2-0.3 0.4-0.5 0.5 -0.2 0.1-0.5 0.2-0.7 0.2C470.5 844.9 470.2 844.8 469.9 844.5z'/%3e%3cpath class='st5' d='M552.3 268.2c0 0 0.1 0 0.1 0.1s0.1 0.1 0.2 0.1c0.1 0 0.2 0.1 0.3 0.2 0.1 0.1 0.1 0.1 0.2 0.2 0 0.1 0.1 0.1 0.1 0.2 0 0.1 0 0.2 0 0.3v1.9c0 0.3-0.1 0.6-0.3 0.9 -0.2 0.2-0.5 0.3-0.9 0.3h-15.6c-0.3 0-0.6-0.1-0.9-0.3 -0.2-0.2-0.3-0.5-0.3-0.9v-1.9c0-0.2 0.1-0.4 0.3-0.6 0.2-0.2 0.4-0.3 0.5-0.4 0.1-0.1 0.2-0.1 0.3-0.2l4.7-2.5c-0.8-0.6-1.4-1.5-1.7-2.5 -0.4-1.1-0.6-2-0.6-2.9v-3.1c0-0.4 0.1-0.8 0.3-1.2 0.2-0.4 0.5-0.8 0.8-1.2 0.3-0.3 0.8-0.7 1.2-1s0.9-0.5 1.5-0.7c0.5-0.1 1.1-0.2 1.6-0.2 0.9 0 1.8 0.2 2.6 0.6s1.5 1 2 1.7 0.8 1.3 0.8 2v3.1c0 0.9-0.1 1.9-0.5 3 -0.3 1-0.9 1.9-1.7 2.5l4.5 2.5L552.3 268.2zM552 269.7c-0.1-0.1-0.2-0.1-0.3-0.2l-0.1 0L547 267c-0.4-0.2-0.7-0.6-0.7-1.2 0-0.5 0.1-0.9 0.5-1.3 0.5-0.4 1-1.1 1.2-1.9 0.2-0.8 0.4-1.6 0.4-2.3v-3.1c0-0.6-0.4-1.2-1.2-1.9 -0.8-0.6-1.7-1-2.7-1 -1 0-1.9 0.3-2.7 1 -0.8 0.6-1.3 1.3-1.3 1.9v3.1c0 0.3 0 0.6 0.1 1 0 0.4 0.1 0.8 0.3 1.2 0.1 0.4 0.3 0.8 0.5 1.2 0.2 0.4 0.5 0.7 0.8 0.9 0.4 0.3 0.6 0.7 0.5 1.3 0 0.1 0 0.1 0 0.2 0 0.1 0 0.1-0.1 0.2 0 0.1 0 0.1-0.1 0.2 0 0-0.1 0.1-0.1 0.2 0 0-0.1 0.1-0.1 0.1 0 0-0.1 0.1-0.2 0.1l-4.7 2.5 -0.1 0c-0.1 0-0.2 0.1-0.3 0.2v1.3H552V269.7zM557.5 264.7c0.2 0.1 0.4 0.2 0.6 0.5 0.2 0.2 0.3 0.4 0.3 0.6v1.8c0 0.2 0 0.4-0.1 0.6 -0.1 0.2-0.2 0.3-0.4 0.4 -0.2 0.1-0.4 0.1-0.6 0.1h-2.4c-0.1-0.2-0.1-0.4-0.2-0.6 0-0.1-0.1-0.3-0.2-0.4s-0.2-0.3-0.3-0.4h2.9v-1.4c0 0 0 0-0.1 0 0 0 0 0-0.1 0s0 0-0.1 0 0 0-0.1 0l0 0c0 0 0 0-0.1 0l-4.6-2.5c-0.1 0-0.2-0.1-0.2-0.2 -0.1 0-0.1-0.1-0.2-0.2 0-0.1-0.1-0.1-0.1-0.2s-0.1-0.1-0.1-0.2c0-0.1 0-0.2 0-0.3 0-0.5 0.1-0.9 0.5-1.3 0.5-0.4 1-1.1 1.3-1.9 0.3-0.8 0.4-1.6 0.4-2.3v-3.1c0-0.6-0.4-1.2-1.3-1.9s-1.8-1-2.8-1c-1 0-1.9 0.3-2.8 0.9 -0.1 0-0.2 0-0.3-0.1 -0.1 0-0.2 0-0.4 0 -0.1 0-0.2 0-0.3 0 -0.1 0-0.2 0-0.4 0 -0.1 0-0.3 0-0.3 0 0.5-0.6 1.2-1.2 2-1.6s1.7-0.6 2.5-0.6c0.7 0 1.3 0.1 2 0.4 0.7 0.2 1.3 0.6 1.8 1 0.5 0.4 0.9 0.9 1.2 1.4 0.3 0.5 0.5 1 0.5 1.5v3.1c0 0.4 0 0.8-0.1 1.3 -0.1 0.4-0.2 0.9-0.3 1.5 -0.1 0.5-0.4 1-0.7 1.5 -0.3 0.5-0.6 0.9-1 1.2l4.6 2.5L557.5 264.7z'/%3e%3cpath class='st5' d='M513.8 809.5v4.5c0 0.7 0.6 1.2 1.2 1.2s1.2-0.6 1.2-1.2v-4.5h4.5c0.7 0 1.2-0.6 1.2-1.2s-0.6-1.2-1.2-1.2h-4.5v-4.5c0-0.7-0.6-1.2-1.2-1.2s-1.2 0.6-1.2 1.2v4.5h-4.5c-0.7 0-1.2 0.6-1.2 1.2s0.6 1.2 1.2 1.2H513.8z'/%3e%3cpath class='st5' d='M857.6 395.7c-1.6 0-2.7 0-3.6 0 -0.9 0-1.5-0.1-2-0.2s-0.8-0.2-0.9-0.2 -0.3-0.2-0.6-0.4c-0.2-0.2-0.6-0.3-1.2-0.4 -0.6-0.1-1.5-0.2-2.8-0.3 -0.2 0-0.4-0.1-0.5-0.2 0 0-0.1-0.1-0.2-0.3 -0.1-0.1-0.2-0.4-0.3-0.7 -0.1-0.3-0.3-0.7-0.4-1.1 -0.1-0.4-0.2-0.9-0.3-1.5 -0.1-0.6-0.1-1.2-0.1-1.8 0-2.1 0.3-3.7 1.1-4.8 0.1-0.2 0.3-0.3 0.6-0.3 1.2 0 2.5-0.7 3.9-2.2s2.7-3.5 3.7-5.9c0 0 0.1-0.1 0.1-0.3 0-0.1 0.1-0.2 0.1-0.3 0 0 0-0.1 0.1-0.2 0-0.1 0.1-0.2 0.2-0.2 0 0 0.1-0.1 0.2-0.1s0.2-0.1 0.3-0.1c0.1 0 0.2 0 0.3 0 0.1 0 0.3 0 0.4 0 0.2 0 0.5 0 0.8 0.2 0.3 0.1 0.5 0.3 0.7 0.4 0.2 0.2 0.4 0.4 0.5 0.6 0.3 0.4 0.4 1.1 0.5 1.9 0 0.8 0 1.6-0.1 2.3 -0.1 0.7-0.2 1.4-0.4 2 2.5 0 4.3 0 5.2 0 0.8 0 1.5 0.2 2 0.7 0.5 0.4 0.8 1.1 0.8 1.8 0 0.6 0 1.1-0.2 1.4 0.2 0.2 0.4 0.5 0.6 0.8 0.1 0.2 0.2 0.6 0.3 0.9 0 0.7-0.3 1.4-1 2 0 0 0 0.1 0.1 0.2 0 0.1 0.1 0.2 0.1 0.3 0 0 0 0.1 0 0.3 0 0.1 0 0.2 0 0.3 0 0.8-0.5 1.5-1.4 2.1 0 0.5 0 0.9 0 1.3C864 394.9 861.8 395.7 857.6 395.7zM846.9 392.8c2.3 0.2 3.8 0.5 4.5 1 0.2 0.2 0.4 0.3 0.6 0.3 0.2 0 0.7 0.1 1.6 0.1s2.2 0.1 4.1 0.1c0.6 0 1.1 0 1.6 0 0.5 0 1-0.1 1.7-0.1 0.6 0 1.1-0.2 1.5-0.4 0.4-0.2 0.6-0.4 0.7-0.7 0-0.3-0.1-0.6-0.4-1 0-0.2 0-0.3 0-0.5 0-0.2 0.2-0.3 0.3-0.4l0 0c0 0 0.1 0 0.2-0.1 0.1 0 0.2-0.1 0.4-0.2 0.2-0.1 0.3-0.2 0.5-0.4 0.1-0.1 0.2-0.3 0.2-0.5 0 0 0-0.1 0-0.1s0-0.1 0-0.1 0-0.1 0-0.1c0 0 0-0.1 0-0.1 0 0 0 0 0-0.1 0 0 0 0 0-0.1l0 0 0 0c0 0-0.1-0.1-0.1-0.2s0-0.2 0-0.2c0-0.1 0-0.1 0.1-0.2 0-0.1 0.1-0.1 0.2-0.2 0.1 0 0.2-0.1 0.3-0.2s0.2-0.2 0.4-0.4c0.1-0.2 0.2-0.4 0.2-0.6 0-0.3-0.3-0.7-0.8-1 -0.1 0-0.1-0.1-0.2-0.2 0-0.1-0.1-0.1-0.1-0.3 0 0 0-0.1 0-0.2 0 0 0-0.1 0-0.2 0 0 0-0.1 0.1-0.2l0 0c0 0 0-0.1 0.1-0.1s0.1-0.1 0.1-0.2c0-0.1 0-0.2 0.1-0.3 0-0.1 0-0.2 0-0.3 0-0.2-0.1-0.5-0.2-0.6 -0.1-0.2-0.3-0.3-0.5-0.3 -0.2 0-0.3-0.1-0.4-0.1 -0.1 0-0.2 0-0.3 0 -0.5 0-1.3 0-2.3 0 -1 0-1.9 0-2.7 0h-1.2c0 0-0.1 0-0.2 0 0 0-0.1 0-0.1 0 0 0-0.1 0-0.1-0.1 0 0-0.1-0.1-0.1-0.1 -0.1-0.2-0.1-0.4 0-0.6 0.2-0.6 0.4-1.4 0.5-2.1 0.1-0.8 0.2-1.6 0.2-2.2 0-0.7-0.1-1.2-0.3-1.6 0 0 0-0.1-0.1-0.1 0 0 0-0.1-0.1-0.1 0 0 0 0-0.1-0.1s-0.1-0.1-0.1-0.1c0 0-0.1 0-0.2 0 -0.1 0-0.2 0-0.3 0 0 0-0.1 0-0.1 0s-0.1 0.1-0.2 0.2c-0.1 0.1-0.1 0.2-0.2 0.4 -1.1 2.7-2.4 4.8-4 6.3 -1.6 1.6-3.1 2.4-4.5 2.6 -0.1 0.2-0.2 0.5-0.3 0.8 -0.1 0.2-0.2 0.7-0.3 1.2 -0.1 0.5-0.1 1.2-0.1 1.8s0 1.3 0.2 1.9c0.1 0.6 0.2 1.1 0.4 1.5C846.6 392.2 846.7 392.5 846.9 392.8z'/%3e%3cpath class='st5' d='M1163.9 453.5c0.3 0.2 0.6 0.5 0.7 0.8 0.1 0.3 0.2 0.6 0.2 0.8v11c0 0.3-0.1 0.7-0.3 1 -0.2 0.3-0.5 0.6-0.8 0.8s-0.6 0.3-0.9 0.3h-18c-0.4 0-0.9-0.2-1.3-0.6 -0.4-0.4-0.6-0.9-0.6-1.4v-11c0-0.6 0.2-1.1 0.7-1.5 0.5-0.4 0.9-0.5 1.4-0.5h3.2l1.7-2.7h8.2l1.7 2.7h3.2C1163.2 453.1 1163.6 453.2 1163.9 453.5zM1163.5 455.2c0 0 0-0.1 0-0.2 0-0.1-0.1-0.2-0.2-0.3 -0.1-0.1-0.2-0.2-0.4-0.2h-3.9l-0.4-0.7 -1.2-2.1h-6.7l-1.7 2.7h-3.9c-0.1 0-0.2 0.1-0.4 0.2 -0.2 0.1-0.3 0.3-0.3 0.4v11.1c0 0.2 0 0.3 0.2 0.4 0.1 0.1 0.2 0.2 0.3 0.2h18c0.1 0 0.2-0.1 0.4-0.2 0.1-0.1 0.2-0.3 0.2-0.4L1163.5 455.2 1163.5 455.2zM1158.6 460c0 1.3-0.5 2.5-1.4 3.4 -0.9 0.9-2 1.4-3.4 1.4 -1.3 0-2.5-0.5-3.4-1.4 -0.9-0.9-1.4-2-1.4-3.4 0-1.3 0.5-2.5 1.4-3.4s2-1.4 3.4-1.4c1.3 0 2.5 0.5 3.4 1.4C1158.2 457.5 1158.6 458.6 1158.6 460zM1157.3 460c0-0.9-0.3-1.8-1-2.4 -0.7-0.7-1.5-1-2.4-1 -0.9 0-1.8 0.3-2.4 1s-1 1.5-1 2.4c0 1 0.3 1.8 1 2.4 0.7 0.7 1.5 1 2.4 1 0.9 0 1.8-0.3 2.4-1C1156.9 461.7 1157.3 460.9 1157.3 460z'/%3e%3cpath class='st5' d='M865.2 853.8c0.8 0.4 1.2 0.9 1.2 1.6v1.8c0 0.4-0.1 0.7-0.4 0.9 -0.2 0.2-0.6 0.4-1 0.4h-19.2c-0.2 0-0.3 0-0.5-0.1 -0.2 0-0.3-0.1-0.4-0.3 -0.1-0.1-0.2-0.2-0.3-0.4 0-0.1-0.1-0.3-0.1-0.5v-1.8c0-0.2 0-0.4 0.1-0.6 0.1-0.2 0.2-0.3 0.3-0.4 0.1-0.1 0.2-0.2 0.4-0.3 0.1-0.1 0.2-0.1 0.3-0.2 0 0 0.1 0 0.1 0l5.9-2.8c-0.1-0.1-0.5-0.2-0.9-0.3 -0.5-0.1-0.9-0.2-1.4-0.2 -0.4 0-0.8-0.1-1.2-0.3 -0.4-0.1-0.6-0.3-0.6-0.4l0.3-0.5c0.2-0.3 0.4-0.9 0.7-1.6 0.2-0.7 0.4-1.5 0.5-2.2 0-0.2 0-0.6 0.1-1 0-0.4 0.1-0.9 0.2-1.4 0-0.5 0.1-1 0.2-1.6 0.1-0.9 0.4-1.8 0.9-2.5 0.5-0.7 1.2-1.3 2-1.7s1.8-0.6 2.8-0.6c1.5 0 2.8 0.4 3.9 1.4s1.7 2 1.9 3.5c0.1 0.7 0.2 1.5 0.3 2.4 0.1 0.9 0.2 1.4 0.2 1.6 0 0.4 0.1 0.9 0.3 1.4s0.2 0.9 0.4 1.2c0.1 0.3 0.2 0.6 0.4 0.9 0.1 0.3 0.2 0.5 0.3 0.6 0 0.1 0.1 0.1 0.1 0.2 0 0.2-0.3 0.3-0.6 0.4 -0.4 0.1-0.8 0.2-1.2 0.3 -0.4 0-0.9 0.1-1.4 0.2 -0.5 0.1-0.8 0.2-0.9 0.3L865.2 853.8C865.1 853.7 865.1 853.7 865.2 853.8zM865 857.1v-1.8c0 0 0-0.1-0.2-0.1 -0.1 0-0.2-0.1-0.3-0.1l-0.1 0 -6-2.9c0 0-0.1 0-0.2-0.1 0 0-0.1-0.1-0.2-0.2 0 0-0.1-0.1-0.1-0.2s-0.1-0.1-0.1-0.2c0-0.1 0-0.1 0-0.2s0-0.2 0-0.2c0-0.2 0-0.3 0.1-0.5 0-0.1 0.1-0.3 0.3-0.4 0.1-0.1 0.2-0.2 0.4-0.3 0.3-0.1 1-0.3 2-0.5 0.3 0 0.6-0.1 0.8-0.1 -0.5-1.2-0.8-2.3-1-3.5 0 0 0-0.1 0-0.2 0-0.1 0-0.2 0-0.3 0-0.1 0-0.2 0-0.3 0-0.1 0-0.2 0-0.3 -0.1-1-0.3-1.9-0.3-2.8 -0.1-1.1-0.6-1.9-1.4-2.6 -0.8-0.7-1.8-1-3-1s-2.1 0.3-3 1c-0.8 0.7-1.3 1.6-1.4 2.6 0 0.5-0.1 1-0.2 1.4 0 0.4-0.1 0.9-0.2 1.4 0 0.5-0.1 0.9-0.1 1.2 -0.1 1.2-0.5 2.3-1 3.5 0.2 0 0.5 0.1 0.8 0.1 1 0.2 1.7 0.3 2 0.5 0 0 0.1 0 0.1 0.1 0 0 0.1 0 0.1 0.1 0 0 0.1 0.1 0.1 0.1 0 0 0.1 0.1 0.1 0.1 0 0 0 0.1 0.1 0.1s0 0.1 0.1 0.1c0 0 0 0.1 0 0.1s0 0.1 0 0.1c0 0 0 0.1 0 0.2 0 0.3 0 0.5-0.2 0.7 -0.1 0.2-0.3 0.4-0.5 0.5l-6 2.8 -0.1 0c-0.1 0-0.2 0.1-0.3 0.2 -0.1 0-0.1 0.1-0.1 0.1v1.8L865 857.1 865 857.1z'/%3e%3cpath class='st5' d='M277.2 337.4l-3.6 3 3 2.4c0.1 0 0.1 0.1 0.2 0.2 0 0.1 0 0.2 0 0.3 0 0.2-0.1 0.4-0.3 0.5l-2.7 1.8c0 0 0 0.1 0 0.1v3.2c0 0.2-0.1 0.4-0.3 0.6l-6.8 3.9c0 0-0.1 0-0.2 0.1 0 0-0.1 0-0.2 0 -0.1 0-0.2 0-0.3-0.1l-6.9-3.9c-0.2-0.1-0.3-0.3-0.3-0.6v-2.8c0-0.2 0.1-0.3 0.2-0.5l-2.8-1.9c-0.2-0.1-0.3-0.3-0.3-0.5 0-0.2 0.1-0.4 0.3-0.5l3-2.4 -3.6-3c-0.2-0.1-0.3-0.3-0.2-0.6 0-0.2 0.1-0.4 0.3-0.5l6.1-3.8c0.3-0.2 0.5-0.1 0.8 0l3.8 3 3.8-3c0.2-0.2 0.5-0.2 0.8 0l6.1 3.8c0.2 0.1 0.3 0.3 0.3 0.5C277.4 337.1 277.4 337.3 277.2 337.4zM260.4 339.6l4.9-3.2 -3.1-2.5 -4.9 3.1L260.4 339.6zM257.8 343.3l4.7 3.1 2.7-2.1 -4.8-3L257.8 343.3zM260.2 348.7l5.5 3.1v-6l-2.8 2.1c-0.1 0.1-0.2 0.1-0.4 0.1 -0.1 0-0.3 0-0.4-0.1l-1.9-1.3L260.2 348.7 260.2 348.7zM266.5 337.3l-4.8 3.2 4.8 3 4.8-3L266.5 337.3zM272.6 348.7v-2.1l-1.9 1.3c0 0-0.1 0-0.2 0.1 0 0-0.1 0-0.2 0 0 0-0.1 0-0.2 0 0 0-0.1 0-0.2-0.1l-2.9-2.2v6.1L272.6 348.7zM275.6 337l-4.9-3.1 -3.1 2.5 4.9 3.2L275.6 337zM272.5 341.3l-4.8 3 2.7 2.1 4.7-3.1L272.5 341.3z'/%3e%3cpath class='st5' d='M266.3 584.8c-0.1 0.1-0.2 0.3-0.3 0.4 -0.1 0.1-0.3 0.1-0.5 0.1l-5.3 0.2 -3.3 4.3c-0.2 0.3-0.5 0.4-0.7 0.4 -0.1 0-0.1 0-0.1 0 -0.3-0.1-0.6-0.3-0.7-0.6l-1.6-4.3c-0.1 0.1-0.1 0.1-0.1 0.2l-15.3 15.3c-0.2 0.2-0.4 0.3-0.7 0.3s-0.5-0.1-0.7-0.3c-0.1-0.1-0.2-0.3-0.3-0.5 -0.1-0.1-0.1-0.3 0-0.5 0.1-0.1 0.1-0.3 0.3-0.4l15.3-15.3c0 0 0-0.1 0.1-0.1l-4-1.4c-0.1 0-0.1-0.1-0.2-0.1 -0.1-0.1-0.1-0.1-0.1-0.1 -0.1-0.1-0.1-0.1-0.1-0.1 0-0.1-0.1-0.1-0.1-0.2s-0.1-0.1-0.1-0.2c-0.1-0.2 0-0.3 0.1-0.5 0.1-0.1 0.1-0.3 0.3-0.4l4.3-3.3 0.1-5.4c0-0.4 0.2-0.7 0.5-0.8 0.3-0.1 0.7-0.1 0.9 0.1l4.5 3 5.1-1.5c0.3-0.1 0.7 0 0.9 0.3s0.3 0.6 0.3 0.9l-1.4 5.2 3 4.4C266.4 584.1 266.4 584.5 266.3 584.8zM263.8 583.5l-2.4-3.4c0-0.1-0.1-0.1-0.1-0.1 0-0.1-0.1-0.1-0.1-0.1 0-0.1 0-0.1 0-0.1 0-0.1 0-0.1 0-0.1s0-0.1 0-0.2l1.1-3.9 -3.9 1.2c-0.3 0.1-0.5 0.1-0.8-0.1l-3.4-2.3 -0.1 4.1c0 0.1 0 0.2-0.1 0.3s-0.1 0.1-0.1 0.3c-0.1 0.1-0.1 0.1-0.2 0.2l-3.2 2.6 3.9 1.4c0.3 0.1 0.5 0.3 0.5 0.5l1.4 3.9 2.6-3.3c0.2-0.3 0.4-0.3 0.7-0.3L263.8 583.5z'/%3e%3cpath class='st5' d='M800.4 204.1c0 0.1 0.1 0.2 0.1 0.4 0 0.2 0.1 0.3 0.1 0.4 0 0.1 0 0.2 0 0.3 0 0.1 0 0.2 0 0.3 0 0.1 0 0.2-0.1 0.3 0 0.1-0.1 0.2-0.2 0.3 -0.4 0.4-1 0.4-1.9 0.1l-4-1.3c-0.3 1-1 1.8-1.9 2.2 -0.9 0.5-1.9 0.5-2.9 0.2 -1-0.3-1.8-1-2.2-1.9 -0.5-0.9-0.5-1.9-0.2-2.9l-3.9-1.3c-0.9-0.3-1.5-0.7-1.6-1.3 0-0.1 0-0.3 0-0.5s0.1-0.3 0.2-0.4c0.1-0.1 0.2-0.2 0.4-0.4 0.2-0.1 0.3-0.3 0.4-0.4 0.1-0.1 0.3-0.2 0.6-0.4 0 0 0.3-0.2 0.7-0.4 0.4-0.3 0.6-0.4 0.8-0.6 0.1-0.1 0.4-0.3 0.6-0.5 0.3-0.2 0.5-0.5 0.7-0.7 0.1-0.2 0.3-0.5 0.3-0.7l1.5-4.5c0.4-1.3 1.1-2.3 2-3.3 0.9-0.9 2-1.5 3.2-1.8 1.2-0.3 2.4-0.2 3.6 0.1 0.9 0.3 1.7 0.8 2.4 1.4 0.7 0.6 1.2 1.4 1.6 2.2s0.6 1.7 0.6 2.7 0 1.9-0.4 2.9l-1.5 4.5c0 0.2-0.1 0.4-0.1 0.7 0 0.2 0 0.5 0 0.8 0 0.3 0 0.5 0.1 0.7 0 0.2 0.1 0.5 0.2 0.8s0.1 0.5 0.2 0.7c0 0.2 0.1 0.4 0.2 0.7C800.3 203.8 800.4 204 800.4 204.1zM799 204.9C799 204.9 799.1 204.9 799 204.9 799.1 204.9 799.1 204.9 799 204.9c0-0.1 0-0.2 0-0.2 0 0 0-0.1 0-0.1 0 0 0-0.1 0-0.1 0 0 0-0.1 0-0.1 -0.2-0.5-0.3-0.9-0.4-1.2 -0.1-0.3-0.2-0.7-0.3-1.3 -0.1-0.5-0.2-1-0.1-1.5 0-0.5 0.1-1 0.2-1.4l1.5-4.5c0.1-0.4 0.2-0.9 0.3-1.3 0-0.4 0-0.9 0-1.3 0-0.4-0.1-0.8-0.3-1.2s-0.3-0.8-0.5-1.1c-0.2-0.3-0.4-0.7-0.7-1s-0.6-0.5-0.9-0.8 -0.7-0.4-1.2-0.5c-1.4-0.5-2.8-0.3-4.1 0.4 -1.3 0.8-2.2 1.9-2.8 3.5l-1.5 4.5c-0.1 0.3-0.2 0.6-0.4 0.9 -0.2 0.3-0.3 0.5-0.5 0.7 -0.1 0.2-0.4 0.4-0.7 0.7 -0.3 0.3-0.5 0.5-0.7 0.5 -0.1 0.1-0.4 0.2-0.8 0.5s-0.6 0.4-0.6 0.4c-0.4 0.2-0.6 0.4-0.7 0.6h0c0 0 0 0 0.1 0 0 0 0 0 0.1 0L799 204.9C799 204.9 799 204.9 799 204.9zM791.9 205.9c0.6-0.3 1-0.7 1.2-1.4l-4.5-1.5c-0.1 0.3-0.1 0.6-0.1 0.9 0 0.3 0.1 0.6 0.2 0.9 0.1 0.2 0.3 0.5 0.5 0.7 0.2 0.2 0.5 0.3 0.8 0.4C790.7 206.3 791.3 206.2 791.9 205.9z'/%3e%3c/g%3e%3cpath class='st6' d='M1371.8 537.2c0 0 0 0.1 0 0.1s0 0.1 0 0.2c0 1.5-0.5 2.9-1.6 4 -1.1 1.1-2.4 1.6-4 1.6 -1.5 0-2.9-0.5-4-1.6 -1.1-1.1-1.7-2.4-1.7-4 0-0.2 0-0.5 0.1-0.7 0-0.2 0.1-0.4 0.2-0.7 -0.2-0.1-0.5-0.2-0.8-0.2 -0.3-0.1-0.6-0.1-1-0.1 -0.3 0-0.5 0-0.8 0.1s-0.4 0.1-0.6 0.1c-0.2 0.1-0.3 0.1-0.4 0.2 0.1 0.4 0.2 0.9 0.2 1.4 0 1.5-0.5 2.9-1.6 4 -1.1 1.1-2.4 1.6-4 1.6 -1.5 0-2.9-0.5-4-1.6 -1.1-1.1-1.7-2.4-1.7-4 0-0.1 0-0.2 0-0.3 0-0.1 0-0.2 0-0.2l1.5-9.2v-0.3 -0.1c0.1-0.3 0.1-0.4 0.1-0.6 0-0.2 0.1-0.4 0.2-0.6 0.1-0.3 0.2-0.5 0.3-0.7 0.1-0.2 0.3-0.4 0.5-0.6 0.2-0.2 0.4-0.4 0.7-0.5 0.3-0.1 0.6-0.3 1-0.3 0.4-0.1 0.9-0.2 1.4-0.2 0.2 0 0.4 0.1 0.5 0.2 0.2 0.2 0.2 0.3 0.2 0.5 0 0.2-0.1 0.4-0.2 0.5 -0.2 0.2-0.3 0.2-0.5 0.2 -0.4 0-0.7 0-1 0.1 -0.3 0.1-0.5 0.1-0.7 0.2 -0.2 0.1-0.3 0.2-0.4 0.3 -0.1 0.1-0.2 0.3-0.3 0.4 -0.1 0.2-0.1 0.4-0.2 0.5 0 0.1-0.1 0.3-0.1 0.6l-0.1 0.4c0 0.1-0.2 0.7-0.4 1.9 -0.2 1.2-0.4 2.3-0.5 3.2 1-0.8 2.2-1.2 3.5-1.2 0.7 0 1.4 0.1 1.9 0.3 0.6 0.2 1.2 0.5 1.7 1 0.5 0.4 0.9 0.9 1.2 1.5 0.7-0.3 1.5-0.4 2.4-0.4 0.5 0 0.9 0.1 1.4 0.1 0.4 0.1 0.8 0.2 1 0.3 0.5-0.8 1.2-1.5 2.1-2 0.9-0.5 1.8-0.8 2.8-0.8 0.3 0 0.5 0 0.8 0.1s0.5 0.1 0.7 0.2c0.2 0.1 0.5 0.2 0.7 0.2 0.2 0.1 0.4 0.2 0.6 0.3 0.2 0.1 0.4 0.3 0.6 0.4 -0.1-0.9-0.3-1.9-0.5-3.1 -0.2-1.2-0.3-1.8-0.3-1.9 0-0.1-0.1-0.2-0.1-0.4 -0.1-0.3-0.1-0.5-0.1-0.7 0-0.2-0.1-0.3-0.2-0.5 -0.1-0.2-0.3-0.4-0.4-0.5 -0.2-0.1-0.4-0.2-0.7-0.3 -0.3-0.1-0.7-0.1-1.1-0.1 -0.2 0-0.4-0.1-0.6-0.2 -0.2-0.2-0.2-0.3-0.2-0.5 0-0.2 0.1-0.4 0.2-0.5 0.2-0.2 0.3-0.2 0.6-0.2 0.4 0 0.9 0.1 1.2 0.1 0.4 0.1 0.7 0.2 1 0.3s0.5 0.3 0.7 0.4c0.2 0.1 0.4 0.3 0.5 0.5 0.2 0.2 0.3 0.4 0.3 0.5 0.1 0.2 0.2 0.4 0.2 0.6 0.1 0.2 0.1 0.4 0.1 0.5 0 0.1 0.1 0.3 0.1 0.5v0.1c0.1 0.1 0.1 0.2 0.1 0.3 1 6.1 1.5 9.2 1.5 9.3C1371.9 537 1371.9 537.1 1371.8 537.2zM1354.6 540.3c0.8-0.8 1.2-1.7 1.2-2.8 0-0.8-0.2-1.4-0.5-2 -0.4-0.6-0.9-1.1-1.5-1.5 -0.6-0.4-1.3-0.5-2-0.5 -1.1 0-2.1 0.4-2.9 1.2 -0.8 0.8-1.2 1.7-1.2 2.8 0 1.1 0.4 2 1.2 2.8 0.8 0.8 1.7 1.2 2.9 1.2C1353 541.5 1353.9 541.1 1354.6 540.3zM1367.8 541.1c0.5-0.2 0.9-0.5 1.2-0.9 0.3-0.4 0.6-0.8 0.9-1.3 0.2-0.5 0.3-1 0.3-1.6 0 0 0-0.1 0-0.2 0-0.1-0.1-0.1-0.1-0.2 0-0.1 0-0.1 0-0.1s0-0.1 0-0.1 0-0.1 0-0.1c0-0.1 0-0.1 0-0.1 -0.1-0.6-0.4-1.1-0.8-1.6s-0.8-0.9-1.4-1.1 -1.1-0.4-1.8-0.4c-1.1 0-2.1 0.4-2.9 1.2 -0.8 0.8-1.2 1.7-1.2 2.8s0.4 2 1.2 2.8c0.8 0.8 1.7 1.2 2.9 1.2C1366.8 541.5 1367.4 541.4 1367.8 541.1z'/%3e%3cpath class='st6' d='M1209 388.4c-0.2 0.4-0.4 0.6-0.9 0.6h-16.5c-0.2 0-0.3-0.1-0.5-0.2 -0.2-0.1-0.3-0.2-0.4-0.4 -0.2-0.4-0.1-0.7 0.2-1l5.1-6.1v-10.6h-0.6c-0.3 0-0.5-0.1-0.7-0.3 -0.2-0.2-0.3-0.4-0.3-0.7s0.1-0.5 0.3-0.6c0.2-0.2 0.4-0.3 0.7-0.3h1.6c0.3 0 0.5 0.1 0.6 0.3 0.2 0.2 0.3 0.4 0.3 0.7v11.9c0 0.3-0.1 0.5-0.2 0.6l-4 4.7h12.2l-4-4.7c-0.2-0.2-0.2-0.4-0.2-0.6v-11.9c0-0.3 0.1-0.5 0.3-0.7 0.2-0.2 0.4-0.3 0.6-0.3h1.6c0.3 0 0.5 0.1 0.7 0.3 0.2 0.2 0.3 0.4 0.3 0.6s-0.1 0.5-0.3 0.7c-0.2 0.2-0.4 0.3-0.7 0.3h-0.6v10.6l5.1 6.1C1209.1 387.7 1209.2 388 1209 388.4zM1198.6 367.8c-0.1 0-0.2-0.1-0.3-0.1 -0.1-0.1-0.2-0.1-0.3-0.2 -0.1-0.1-0.2-0.1-0.3-0.2 -0.1-0.1-0.2-0.2-0.2-0.2 -0.1-0.1-0.1-0.2-0.2-0.3 -0.1-0.1-0.1-0.2-0.2-0.3 -0.1-0.1-0.1-0.2-0.1-0.3 0-0.1-0.1-0.2-0.1-0.3 0-0.3 0.1-0.5 0.2-0.8 0.1-0.2 0.2-0.4 0.4-0.6 0.2-0.2 0.4-0.3 0.6-0.4 0.2-0.1 0.5-0.2 0.8-0.2 0.5 0 1 0.2 1.4 0.5 0.4 0.4 0.6 0.8 0.6 1.4 0 0.5-0.2 1-0.6 1.4 -0.4 0.4-0.8 0.6-1.4 0.6C1198.8 367.8 1198.7 367.8 1198.6 367.8zM1201.8 361.6c0-0.9 0.3-1.7 1-2.4 0.6-0.6 1.5-1 2.4-1s1.7 0.3 2.4 1c0.6 0.6 1 1.5 1 2.4 0 0.9-0.3 1.7-1 2.4 -0.6 0.6-1.5 1-2.4 1s-1.7-0.3-2.4-1S1201.8 362.5 1201.8 361.6zM1204.1 360.6c-0.3 0.3-0.4 0.6-0.4 1 0 0.3 0.1 0.5 0.2 0.7 0.1 0.2 0.3 0.4 0.5 0.5 0.2 0.1 0.5 0.2 0.7 0.2 0.4 0 0.8-0.2 1-0.4 0.3-0.3 0.4-0.6 0.4-1 0-0.2-0.1-0.4-0.1-0.6 -0.1-0.2-0.2-0.3-0.3-0.5 -0.1-0.1-0.3-0.2-0.5-0.3 -0.2-0.1-0.4-0.1-0.6-0.1C1204.8 360.2 1204.5 360.3 1204.1 360.6z'/%3e%3cpath class='st6' d='M178 521.9c-0.6 0-1.1-0.1-1.6-0.2s-1-0.3-1.4-0.5c-0.4-0.2-0.7-0.4-1-0.6 -0.2-0.2-0.5-0.4-0.8-0.6 -0.2-0.2-0.5-0.4-0.9-0.8 -0.1-0.1-0.2-0.2-0.2-0.2s-0.1-0.1-0.2-0.2c-0.1-0.1-0.2-0.1-0.2-0.2 -0.1-0.1-0.1-0.1-0.2-0.2 -0.1-0.1-0.1-0.1-0.2-0.1 -0.1 0-0.1-0.1-0.1-0.1 0 0-0.1 0-0.1 0 0 0-0.1 0-0.1 0l0 0c-0.1 0.1-0.4 0.3-0.9 0.7 -0.1 0.1-0.2 0.2-0.3 0.2 -0.1 0.1-0.2 0.1-0.2 0.2 -0.1 0.1-0.2 0.2-0.3 0.2 -0.1 0.1-0.2 0.2-0.3 0.2l-0.1 0.1c-0.4 0.3-0.6 0.5-0.9 0.6 -0.2 0.2-0.5 0.3-0.9 0.5 -0.4 0.2-0.9 0.4-1.3 0.5 -0.5 0.1-1 0.2-1.5 0.2 -0.9 0-1.7-0.2-2.4-0.5 -0.8-0.4-1.4-0.9-1.9-1.5 -1-1.2-1.3-2.7-0.9-4.5 0.1-0.3 0.2-0.5 0.5-0.6 0.3-0.1 0.5-0.1 0.8 0.2 0.4 0.3 0.9 0.4 1.4 0.4 0.4 0 0.9-0.1 1.4-0.3 0.2-0.1 0.5-0.3 0.7-0.5 0.2-0.2 0.4-0.5 0.7-0.9 0.3-0.4 0.4-0.6 0.5-0.7 0.3-0.3 0.5-0.5 0.6-0.7 0.2-0.2 0.4-0.4 0.7-0.6 0.3-0.2 0.6-0.4 0.9-0.5 0.3-0.1 0.6-0.2 1-0.2 0.5 0 1 0.1 1.5 0.3 0.5 0.2 0.9 0.5 1.4 0.9 0.4-0.4 0.9-0.6 1.4-0.9 0.5-0.2 1-0.3 1.5-0.3 0.4 0 0.8 0.1 1.1 0.2 0.3 0.1 0.6 0.3 0.9 0.5 0.3 0.2 0.5 0.4 0.7 0.6 0.2 0.2 0.4 0.4 0.7 0.8 0.1 0.1 0.3 0.3 0.5 0.7 0.3 0.3 0.5 0.6 0.8 0.9 0.3 0.2 0.4 0.4 0.7 0.5 0.5 0.2 0.9 0.3 1.4 0.3 0.6 0 1.1-0.2 1.5-0.4 0.2-0.2 0.5-0.2 0.8-0.1 0.3 0.1 0.4 0.3 0.5 0.6 0.1 0.5 0.1 1.1 0.1 1.5 0 0.4-0.1 0.8-0.2 1.2 -0.1 0.4-0.3 0.7-0.4 1s-0.3 0.5-0.5 0.8c-0.5 0.6-1.2 1.1-1.9 1.5C179.6 521.7 178.8 521.9 178 521.9zM171 516.8c0.1 0 0.1 0 0.1 0s0 0 0.1 0c0.1 0 0.1 0 0.1 0h0.1 0.1c0.2 0 0.4 0.1 0.6 0.2 0.2 0.1 0.4 0.3 0.5 0.4s0.4 0.3 0.8 0.6c0.3 0.3 0.6 0.5 0.9 0.7 0.3 0.2 0.5 0.4 0.7 0.5 0.2 0.1 0.4 0.3 0.8 0.5 0.3 0.2 0.7 0.3 1.1 0.4 0.4 0.1 0.8 0.1 1.2 0.1 0.4 0 0.8-0.1 1.2-0.2 0.4-0.1 0.8-0.3 1.1-0.5 0.3-0.2 0.6-0.5 0.9-0.8 0.3-0.3 0.4-0.6 0.5-1 0.1-0.4 0.2-0.8 0.2-1.1 -0.1 0.1-0.2 0.1-0.3 0.1 -0.1 0-0.2 0.1-0.3 0.1s-0.2 0.1-0.3 0.1c-0.1 0-0.3 0-0.4 0 -0.6 0-1.4-0.2-2-0.4 -0.2-0.1-0.4-0.2-0.6-0.4 -0.2-0.2-0.4-0.3-0.5-0.5 -0.2-0.2-0.3-0.4-0.5-0.5 -0.2-0.2-0.3-0.3-0.4-0.5 -0.2-0.2-0.3-0.4-0.4-0.5 -0.5-0.5-0.9-0.9-1.2-1.1 -0.3-0.2-0.6-0.3-1-0.3 -0.8 0-1.6 0.4-2.3 1.2 -0.1 0.1-0.1 0.1-0.1 0.1 -0.1 0-0.1 0.1-0.1 0.1s-0.1 0.1-0.1 0.1c-0.1 0-0.1 0.1-0.1 0.1s-0.1 0-0.1 0c-0.2 0-0.4-0.1-0.6-0.3 -0.3-0.3-0.6-0.6-1-0.9 -0.3-0.2-0.8-0.4-1.2-0.4 -0.4 0-0.8 0.1-1 0.3 -0.3 0.2-0.7 0.6-1.1 1.1 -0.1 0.1-0.3 0.3-0.5 0.6 -0.2 0.3-0.4 0.5-0.6 0.7 -0.2 0.2-0.4 0.4-0.6 0.6s-0.5 0.4-0.8 0.5c-0.6 0.3-1.4 0.4-2 0.4 -0.4 0-0.9-0.1-1.2-0.2 0 0.8 0.2 1.6 0.7 2.2 0.4 0.4 0.8 0.8 1.4 1.1s1.2 0.4 1.8 0.4c0.3 0 0.5 0 0.8-0.1 0.3-0.1 0.5-0.1 0.8-0.2 0.2-0.1 0.4-0.2 0.6-0.2 0.2-0.1 0.4-0.2 0.6-0.3 0.2-0.2 0.4-0.3 0.5-0.3 0.1-0.1 0.3-0.2 0.5-0.4l0.1-0.1c0.1-0.1 0.2-0.2 0.4-0.3 0.2-0.1 0.3-0.2 0.3-0.3 0.1-0.1 0.2-0.2 0.3-0.3 0.2-0.2 0.4-0.3 0.5-0.4 0.1-0.1 0.3-0.2 0.4-0.3 0.2-0.1 0.3-0.2 0.4-0.2 0.1 0 0.2-0.1 0.3-0.1l0 0c0.1 0 0.1 0 0.1 0C170.9 516.9 170.9 516.8 171 516.8z'/%3e%3cpath class='st6' d='M721.6 332.2c-2.9 0-5.2-0.9-7-2.7s-2.8-4.1-2.8-6.8c0-0.5 0.1-1.1 0.2-1.8 0.1-0.6 0.3-1.2 0.4-1.6 0.2-0.5 0.3-0.9 0.5-1.4 0.2-0.5 0.3-0.8 0.4-1 0.1-0.2 0.2-0.3 0.2-0.4 0.2-0.3 0.4-0.4 0.8-0.4 0.2 0 0.3 0.1 0.4 0.2 0.1 0.1 0.2 0.2 0.2 0.4 0.3 1.1 0.6 2.1 1.1 2.8 0.4 0.6 0.9 1.1 1.4 1.5 -0.5-1.9-0.5-3.8-0.2-5.7 0.2-1.1 0.5-2.1 1-3 0.5-0.9 1-1.6 1.5-2.1 0.5-0.5 1-0.9 1.6-1.3 0.6-0.4 1-0.6 1.2-0.7 0.3-0.1 0.4-0.2 0.6-0.2 0.1-0.1 0.3-0.1 0.4 0 0.1 0 0.3 0.1 0.4 0.2 0.2 0.2 0.3 0.4 0.2 0.7 0 0.1-0.1 0.3-0.1 0.5 -0.1 0.2-0.1 0.6-0.1 1.2 -0.1 0.6-0.1 1.2 0 1.8 0.1 0.6 0.2 1.2 0.3 2.1 0.2 0.8 0.4 1.5 0.7 2.2 0.1 0.2 0.2 0.3 0.3 0.5 0.1 0.2 0.2 0.4 0.3 0.6 0.1-0.6 0.2-1.1 0.3-1.6 0.3-1.2 1-2.2 2-2.8 0.1-0.1 0.2-0.1 0.2-0.1 0.1-0.1 0.3-0.1 0.4-0.1 0.1 0 0.3 0.1 0.4 0.2 0.1 0.1 0.2 0.2 0.3 0.3 0.1 0.1 0.1 0.3 0.1 0.4 0 0.1 0 0.1 0 0.2 0 0.1 0 0.2 0 0.5 0 0.2 0.1 0.5 0.1 0.8s0.2 0.6 0.3 1c0.2 0.4 0.3 0.8 0.6 1.1 0.5 0.9 0.9 1.7 1.1 2.5 0.2 0.8 0.3 1.7 0.3 2.8 0 1.1-0.2 2.1-0.5 3.1 -0.3 1-0.8 1.8-1.4 2.6 -0.6 0.8-1.3 1.5-2.1 2 -0.8 0.5-1.7 1-2.8 1.3C723.9 332.1 722.7 332.2 721.6 332.2zM714.2 319c-0.6 1.4-0.9 2.7-0.9 3.7 0 2.3 0.8 4.2 2.3 5.7 1.6 1.5 3.5 2.2 6 2.2s4.5-0.8 6.1-2.2c1.6-1.5 2.4-3.4 2.4-5.7 0-0.6-0.1-1.2-0.1-1.7 -0.1-0.5-0.2-0.9-0.4-1.4 -0.2-0.4-0.4-0.9-0.7-1.5 -0.5-0.9-0.9-1.8-1.1-2.8 -0.2 0.3-0.3 0.6-0.4 0.9 -0.1 0.5-0.2 1-0.3 1.6s-0.1 1-0.1 1.3 0 0.5 0.1 0.6c0 0.2-0.1 0.3-0.1 0.5 -0.1 0.2-0.2 0.3-0.4 0.3 -0.1 0-0.2 0.1-0.2 0.1s-0.2 0-0.2-0.1c-0.1-0.1-0.2-0.1-0.2-0.1 -0.1-0.1-0.1-0.1-0.2-0.2 -1-1.4-1.6-2.4-2-3.3 -0.9-2.1-1.3-4.4-1.1-7.3 -0.4 0.2-0.7 0.5-1 0.8 -0.3 0.3-0.7 0.6-1.1 1.1 -0.4 0.4-0.7 1-1 1.7 -0.3 0.6-0.5 1.4-0.6 2.2 -0.1 0.6-0.2 1.2-0.2 1.9 0 0.6 0.1 1.2 0.1 1.8 0.1 0.5 0.2 1 0.3 1.5s0.2 0.8 0.3 1c0.1 0.2 0.1 0.3 0.1 0.4 0.1 0.1 0.1 0.1 0.1 0.2 0 0.1 0 0.2 0 0.2 0 0.1-0.1 0.1-0.1 0.2 -0.1 0.1-0.1 0.1-0.1 0.2 -0.2 0.2-0.4 0.3-0.8 0.2 -0.1 0-0.2-0.1-0.3-0.1 -0.1-0.1-0.3-0.1-0.6-0.3s-0.6-0.3-0.9-0.5c-0.3-0.2-0.6-0.4-0.9-0.8 -0.3-0.3-0.6-0.7-0.9-1.1 -0.1-0.2-0.2-0.4-0.3-0.6C714.4 319.4 714.3 319.2 714.2 319z'/%3e%3cpath class='st6' d='M318.3 741.7c0.4 0.1 0.4 0.4 0.2 1l-9.7 22.7c-0.2 0.4-0.4 0.6-0.8 0.6 -0.1 0-0.3-0.1-0.4-0.1 -0.1-0.1-0.3-0.2-0.4-0.4l-3.8-6.3c-0.2-0.3-0.3-0.5-0.6-0.8 -0.3-0.3-0.5-0.5-0.8-0.8s-0.5-0.5-0.8-0.6l-6.4-4c-0.2-0.2-0.4-0.3-0.5-0.5 -0.1-0.2-0.1-0.4 0.1-0.5s0.3-0.3 0.5-0.4l22.7-9.6c0.2-0.1 0.4-0.1 0.5-0.1C318.2 741.7 318.2 741.7 318.3 741.7zM303 756.4l11.3-11.5 -17.5 7.4 5.2 3.2C302.3 755.8 302.6 756 303 756.4zM315.4 745.9L304 757.4c0.1 0.1 0.2 0.2 0.3 0.3 0.1 0.1 0.2 0.2 0.2 0.3 0.1 0.1 0.2 0.2 0.2 0.3l3.1 5.1L315.4 745.9z'/%3e%3cpath class='st6' d='M1182 700.3c-1.1 1.1-2.3 1.9-3.7 2.5 -1.4 0.6-2.8 0.9-4.2 0.9 -1.4 0-2.8-0.3-4.2-0.9 -1.4-0.5-2.7-1.4-3.7-2.4 -0.8-0.8-1.4-1.5-1.8-2.4 -0.5-0.9-0.9-1.8-1.1-2.7 -0.2-0.9-0.4-1.9-0.4-2.9s0.1-1.9 0.4-2.9 0.6-1.8 1.1-2.7c0.5-0.9 1.1-1.7 1.8-2.4l7.3-7.3c0 0 0 0 0.1-0.1l2.3-2.3c0.2-0.2 0.3-0.2 0.5-0.2s0.4 0.1 0.6 0.2l4 4c0.2 0.2 0.3 0.4 0.2 0.6 0 0.2-0.1 0.4-0.2 0.5l-0.5 0.5 -8.9 8.9c-0.9 0.9-1.3 1.9-1.4 3.1 -0.1 1.2 0.4 2.2 1.2 3 0.8 0.8 1.8 1.2 2.8 1.1 1-0.1 2.1-0.6 2.9-1.5l7-7 2.3-2.3c0.2-0.2 0.3-0.2 0.5-0.2 0.2 0 0.4 0.1 0.6 0.2l4 4c0.2 0.2 0.3 0.4 0.2 0.6 0 0.2-0.1 0.4-0.2 0.5l-0.5 0.5L1182 700.3zM1176.4 676.5l-2.3 2.3 2.8 2.8 2.3-2.3L1176.4 676.5zM1170.5 701.3c1.2 0.5 2.4 0.7 3.6 0.7 1.2 0 2.4-0.3 3.6-0.8 1.2-0.5 2.3-1.2 3.2-2.1l5.6-5.6 -2.8-2.8 -5.4 5.4c-0.8 0.8-1.7 1.4-2.6 1.7 -0.9 0.3-1.9 0.4-2.9 0.2 -1-0.2-1.8-0.7-2.6-1.5 -1.1-1.1-1.7-2.5-1.7-4.2 0-1.6 0.6-3 1.8-4.2l5.4-5.4 -2.8-2.8 -5.6 5.6c-1.2 1.2-2.1 2.7-2.5 4.3 -0.4 1.7-0.4 3.3 0 5 0.4 1.7 1.2 3.1 2.5 4.3C1168.2 700.1 1169.2 700.8 1170.5 701.3zM1187.1 687.2l-2.3 2.3 2.8 2.8 2.3-2.3L1187.1 687.2z'/%3e%3cpath class='st6' d='M365.1 464.7C365.1 464.7 365.2 464.7 365.1 464.7 365.2 464.7 365.2 464.7 365.1 464.7c0.2 0 0.3 0 0.4 0.1 0.1 0.1 0.3 0.1 0.4 0.2 0.1 0.1 0.2 0.2 0.3 0.3 0.1 0.1 0.2 0.2 0.2 0.3 0.1 0.1 0.1 0.2 0.2 0.4 0.1 0.1 0.1 0.3 0.1 0.4 0 0.1 0 0.1 0 0.2 0 0.1 0 0.1-0.1 0.2l-1.5 7.5h4.7c0.6 0 1.1 0.3 1.4 0.9 0.3 0.6 0.3 1.1-0.1 1.7l-9 12.9c-0.3 0.4-0.8 0.6-1.2 0.6 -0.1 0-0.2 0-0.3 0 -0.1 0-0.2-0.1-0.3-0.1 -0.3-0.2-0.6-0.4-0.8-0.7 -0.2-0.3-0.2-0.6-0.2-1l1.5-8.6h-4.7c-0.1 0-0.2 0-0.3-0.1 -0.1 0-0.2-0.1-0.3-0.1 -0.1-0.1-0.2-0.1-0.3-0.2 -0.1-0.1-0.2-0.2-0.3-0.3 -0.1-0.1-0.2-0.2-0.2-0.3 -0.3-0.6-0.3-1.1 0.1-1.7l9-11.9 0.1-0.1c0 0 0-0.1 0.1-0.1 0.1-0.1 0.2-0.2 0.3-0.3 0.1-0.1 0.2-0.2 0.3-0.2 0.1-0.1 0.2-0.1 0.3-0.1C365 464.7 365 464.7 365.1 464.7L365.1 464.7zM356.2 478.2h6.5l-1.8 10.4 8.9-12.9h-6.5l1.8-9.5L356.2 478.2z'/%3e%3cpath class='st5' d='M742.5 773.1c2.1 0.9 3.7 2.4 4.7 4.7 1.5 3.3 1.2 8.4-0.9 15.5 -0.1 0.5-0.4 0.8-0.8 1l0 0c-0.1 0.1-0.3 0.1-0.6 0.1 -0.2 0-0.4 0-0.5 0 -0.1 0-0.1 0-0.2-0.1 -0.1 0-0.3-0.1-0.5-0.2 -0.8-0.4-1.5-0.7-1.9-0.9s-1.1-0.5-2-1c-0.9-0.4-1.6-0.8-2.1-1.1 -0.5-0.3-1.2-0.7-1.9-1.2 -0.7-0.5-1.3-1-1.8-1.5 -0.5-0.4-0.9-1-1.4-1.6 -0.5-0.6-0.8-1.2-1.1-1.8 -0.5-1.1-0.7-2.2-0.8-3.4 0-1.2 0.1-2.3 0.5-3.4 0.4-1 1-2 1.8-2.9 0.8-0.9 1.7-1.6 2.8-2C738.1 772.2 740.3 772.1 742.5 773.1zM745.9 778.4c-0.4-0.9-0.9-1.6-1.5-2.3 -0.6-0.7-1.3-1.2-2.1-1.6 -0.8-0.4-1.7-0.6-2.7-0.6 -1 0-2.1 0.2-3.2 0.7 -1.2 0.5-2.1 1.4-2.9 2.4 -0.7 1.1-1.2 2.2-1.3 3.6 -0.1 1.3 0.1 2.6 0.6 3.8 0.2 0.5 0.6 1.1 1 1.6 0.4 0.5 0.9 1 1.3 1.4 0.4 0.4 1 0.9 1.7 1.3 0.7 0.4 1.3 0.8 1.8 1.2 0.5 0.3 1.2 0.7 2 1.1s1.5 0.7 1.9 0.9c0.4 0.2 1.1 0.5 1.9 0.9l0.5 0.2c0 0 0.1 0 0.1 0 0 0 0-0.1 0-0.1C746.9 786.2 747.3 781.3 745.9 778.4zM739.2 776.9c0.6 0 1.1 0.1 1.7 0.2 0.5 0.2 1 0.5 1.4 0.9s0.8 0.9 1 1.4c0.5 1.1 0.5 2.2 0.1 3.3 -0.4 1.1-1.2 1.9-2.2 2.4 -1.1 0.5-2.2 0.5-3.3 0.1 -1.1-0.4-1.9-1.2-2.4-2.3 -0.2-0.4-0.3-0.9-0.4-1.3 0-0.4 0-0.9 0-1.4 0.1-0.4 0.2-0.9 0.5-1.2 0.2-0.4 0.5-0.7 0.8-1.1 0.3-0.3 0.7-0.6 1.2-0.8C738 777.1 738.6 777 739.2 776.9zM741.8 782.7c0.5-0.9 0.5-1.8 0.1-2.6 -0.3-0.7-0.9-1.2-1.6-1.5 -0.7-0.3-1.5-0.2-2.2 0.1 -0.7 0.3-1.2 0.9-1.5 1.6 -0.3 0.7-0.2 1.5 0.1 2.2 0.3 0.7 0.9 1.2 1.7 1.5 0.8 0.3 1.5 0.2 2.2 0C741.1 783.6 741.5 783.2 741.8 782.7z'/%3e%3c/svg%3e");}</style>{/literal}
{/block}
{block name="footer"}
<footer>
	<div class="container container-{$app_name}">
	<div class="footer__container">
		{if $config.footer}
			{include file="apps/{$config.theme}/main/templates/footer/footer.tpl"}
		{/if}
	</div>
	</div>
</footer>
{/block}
